package provide UDFAnalysis 1.0

proc APrandomGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set mN RANDOM
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT  [lindex [lindex $apANS($mN) 3] 0]
      set LaB  [format $FmT Base Output Range MaxVal Seed Dist Mean Varience]
      set rDis [list Flat Gaussian]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 30 8  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.0

      GUIblankCol $We 0 2.0
      GUIblankCol $We 2 1.0

      incr R 
      GUILabel $We.l0  "Base"   c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.va grid|$R|3|news 12 apANS($fD,BaseV)
      GUIblankCol $We 4 10
      GUILabel $We.l5 "Distribution"  c grid|$R|5|w -1 0 "" $LFonT
      GUIbuttonToggle $We.dist $apANS($fD,Dist) grid|$R|6|ew $rDis \
                         "GUIoptsToggle $We.dist apANS($fD,Dist) PRI" 0,0.5

      incr R 
      GUILabel $We.l1  "OutPut"  c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.vo grid|$R|3|news 12 apANS($fD,RndV)
      GUILabel $We.l6  "Mean"  c grid|$R|5|w -1 0 "" $LFonT
      GUIboxEntry $We.mean grid|$R|6|news 12 apANS($fD,Mean)

      incr R 
      set rOpt [list PN N P]
      GUILabel $We.l2  "Range"  c grid|$R|1|w -1 0 "" $LFonT
      GUIbuttonMenu $We.rng "" grid|$R|3|w $rOpt  \
                    "GUIoptsProcess $We.rng apANS($fD,Rng) PRI " 6,0.5
      GUILabel $We.l7  "Variance"  c grid|$R|5|w -1 0 "" $LFonT
      GUIboxEntry $We.var grid|$R|6|news 12 apANS($fD,Var)

      incr R 
      GUILabel $We.l3  "Max Value"  c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.max grid|$R|3|news 12 apANS($fD,Max)

      incr R 
      GUILabel $We.l4  "Seed"  c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.seed grid|$R|3|news 12 apANS($fD,Seed)

      bind $W <Down> { APtwinCmd RANDOM %W MOVE DOWN }
      bind $W <Up> { APtwinCmd RANDOM %W MOVE UP }

      APallInits  $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI   $mN $fD

   } else { GUIwindowCtrl $W }
}
