package provide UDFAnalysis 1.0

proc APplot2DAxes { I } {
   global apANS GphInfo PltInfo WinInfo

# SET up all the plot definitions for this plot

   APplotParms $I

   set pN  $apANS($I,Col).$apANS($I,Row)

# SET up which X axes have numerical labels being outout against them

   set xbA $apANS($I,xbAno)
   set xtA $apANS($I,xtAno)
   set ylA $apANS($I,ylAno)
   set yrA $apANS($I,yrAno)
   if [string match ALL $apANS($I,xbnEnds)] { set xbA NO }
   if [string match ALL $apANS($I,xtnEnds)] { set xtA NO }
   if [string match ALL $apANS($I,ylnEnds)] { set ylA NO }
   if [string match ALL $apANS($I,yrnEnds)] { set yrA NO }

   set XL ""
   set XU ""
   if [string match YES $xbA] {  
      if [string match YES $apANS($I,tBased)] { set XL X }
      if [string match YES $xtA] {  
         set XN BOTH
      } else { set XN BOT }
   } elseif [string match YES $xtA] {  
      set XN TOP
      if [string match YES $apANS($I,tBased)] { set XU X }
   } else { set XN NONE }

# IF we need to add a plot grid after the plot is put up do it now.

   if { [string match YES $apANS($I,drG)] && \
        [string match AFTER $apANS(gAdd)] } {
      APplotGrid $pN $apANS($I,tBased)
   }

# SET up which Y axes have numerical labels being outout against them

   if [string match YES $ylA] {  
      if [string match YES $yrA] {  
         set YN BOTH
      } else { set YN BOT }
   } elseif [string match YES $yrA] {  
      set YN TOP
   } else { set YN NONE }

# IF this is a time based plot and we want the time label then we need
#   to add a dummy label in XL

# OUTPUT plot axes and numerical labels

   PLTinfoChg $pN X NUMBERS TCOLOR $GphInfo(White)
   PlotOutlines $pN [list $XL 0.5 "" 0.0 $XU 0.5] [list $XN $YN BOTH BOTH] \
                    [list $apANS(xNo) $apANS(yNo)]
}
