# THIS procedure outputs a color bar.

package provide UDFAnalysis 1.0

proc APoutputCB { pSN } {
   global apANS GphInfo PltInfo WinInfo DevInfo

   APkeepTabs "DRAWING COLORBAR"

# SET the plot number and the index into the plot definitions where the plot
#   information is contained.

   set pN $apANS($pSN,Col).$apANS($pSN,Row)

# SETUP the colorbar option array.  Will add to it as we know more about
#   what type of colorbar is being put up

   set cInputs(WHITE)     NO
   set cInputs(FMT)       $apANS($pSN,cBDir)
   set cInputs(POS)       RELATIVE
   set cInputs(ANNOTATE)  $apANS($pSN,cbAno)
   set cInputs(AXIS)      YES
   set cInputs(PRIMARY)   TICMJ:TICMN:NUM:LABEL
   set cInputs(PNUMS)     $apANS($pSN,cbMjT):$apANS($pSN,cbMnT)
   set cInputs(SNUMS)     $apANS($pSN,cbMjT):$apANS($pSN,cbMnT)
   set cInputs(PCOLORS)   HOLD:HOLD:$apANS($pSN,cbnCol):HOLD
   set cInputs(SCOLORS)   HOLD:HOLD:$apANS($pSN,cbnCol):HOLD
   set cInputs(PBOLD)     $apANS($pSN,cbBold):HOLD
   set cInputs(SBOLD)     $apANS($pSN,cbBold):HOLD
   set cInputs(PSIZE)     HOLD:HOLD:$apANS($pSN,cbTSz):$apANS($pSN,cbTSz)
   set cInputs(SSIZE)     HOLD:HOLD:$apANS($pSN,cbTSz):$apANS($pSN,cbTSz)
   set cInputs(PFMTS)     HOLD:HOLD:$apANS($pSN,cbnFmt)
   set cInputs(SFMTS)     HOLD:HOLD:$apANS($pSN,cbnFmt)
   set cInputs(LEV)       1.0:1.0
   set cInputs(NLEV)      1.0:1.0
   set cInputs(LABELS)   ""

# GET the colorbar corners

  set sC [split $apANS($pSN,cBSpan) ","] 
  set SpaN [lindex $sC 0]
   switch -exact -- $apANS($pSN,cBLoc) {
      LEFT {
         set yT [ expr $apANS($pN,ypT) - $apANS(yC10)]
	 set eR [expr $apANS($pSN,Row) + $SpaN - 1]
	 if { $eR >= $apANS(maxRow) } { set eR [expr $apANS(maxRow) - 1] }
         set pT $apANS($pSN,Col).$eR
	 set yB [ expr $apANS($pT,ypB) + $apANS(yC10)]

         set xL [ expr $apANS($pN,xL) + $apANS(cBWidth) - \
	              ( 1.0 + $apANS($pSN,cbGap)) * $apANS(xC10)]
         set xR [ expr $xL - 2.0 * $apANS(xC10)]
         set cInputs(pMIN) [lindex $apANS($pN.cB) 0]
         set cInputs(pMAX) [lindex $apANS($pN.cB) 1]
         set cInputs(pSCA) $apANS($pSN,cbSca)
      }
      RIGHT {
         set yT [ expr $apANS($pN,ypT) - $apANS(yC10)]
	 set eR [expr $apANS($pSN,Row) + $SpaN - 1]
	 if { $eR >= $apANS(maxRow) } { set eR [expr $apANS(maxRow) - 1] }
         set pT $apANS($pSN,Col).$eR
	 set yB [ expr $apANS($pT,ypB) + $apANS(yC10)]

         set xL [ expr $apANS($pN,xR) - $apANS(cBWidth) + \
	              ( 1.0 + $apANS($pSN,cbGap)) * $apANS(xC10)]
         set xR [ expr $xL + 2.0 * $apANS(xC10)]
         set cInputs(pMIN) [lindex $apANS($pN.cB) 0]
         set cInputs(pMAX) [lindex $apANS($pN.cB) 1]
         set cInputs(pSCA) $apANS($pSN,cbSca)
      }
      BOTTOM {
         set yT [expr $apANS($pN,yB) + $apANS(cBHght) \
	              - (2.0 + $apANS($pSN,cbGap)) * $apANS(yC10)]
         set yB [ expr $yT - 2.0 * $apANS(yC10)]

         set xL [ expr $apANS($pN,xpL)  + 2.0 * $apANS(xC10)]
	 set eC [expr $apANS($pSN,Col) + $SpaN - 1]
	 if { $eC >= $apANS(maxCol) } { set eC [expr $apANS(maxCol) - 1] }
         set pT $eC.$apANS($pSN,Row)
         set xR [ expr $apANS($pT,xpR)  - 2.0 * $apANS(xC10)]

         set cInputs(pMIN) [lindex $apANS($pN.cB) 0]
         set cInputs(pMAX) [lindex $apANS($pN.cB) 1]
         set cInputs(pSCA) $apANS($pSN,cbSca)
      }
      TOP {
         set yT [expr $apANS($pN,yT) + $apANS(cBHght) \
	              - (2.0 + $apANS($pSN,cbGap)) * $apANS(yC10)]
         set yB [ expr $yT - 2.0 * $apANS(yC10)]

         set xL [ expr $apANS($pN,xpL)  + 2.0 * $apANS(xC10)]
	 set eC [expr $apANS($pSN,Col) + $SpaN - 1]
	 if { $eC >= $apANS(maxCol) } { set eC [expr $apANS(maxCol) - 1] }
         set pT $eC.$apANS($pSN,Row)
         set xR [ expr $apANS($pT,xpR)  - 2.0 * $apANS(xC10)]

         set cInputs(pMIN) [lindex $apANS($pN.cB) 0]
         set cInputs(pMAX) [lindex $apANS($pN.cB) 1]
         set cInputs(pSCA) $apANS($pSN,cbSca)
      }
   }

   set cW [ColorBar A $xL $yB 0.0 $xR $yT 0.0 cInputs cI cIb]
}
