# FIT as set of data to a kappa distribution of the form: 
#
#    Y = A * [1 + (X/C)^2]^(-B)
#
# THE function returns Y, dY/dA, dY/dB and dY/dC for any X.

package provide UDFAnalysis 1.0

proc APkappaFunc { nA dYdA Ops } {
    global _X_

    upvar $dYdA dA
    upvar $Ops  oP

    set xV $_X_($oP(4))

# THE coefficients
    set A $oP(5)
    set B $oP(6)
    set C $oP(7)

    set xC [expr $xV * $xV / $C / $C] 
    set ExP [expr -$B]
    set fB [expr 1.0 + $xC]
    set kB [expr pow($fB, $ExP) ]

# THE value of the function

    set yV [expr $A * $kB]

# Derivitive with respect to A is [1 + xC]^(-B)

    set dA(0) $kB

# Derivitive with respect to B is -AB[1 + xC]^(-B - 1)

    set dA(1) [expr $A * $kB * $ExP / $fB]

# Derivitive with respect to C is -2.0 * (1/C) * A* xC * [1 + xC]^(-B)

    set dA(2) [expr -2.0 * $A * $kB * $xC / $C ] 

    return $yV
}
