# THIS procedure reads a moments file created by the moments program

package provide UDFAnalysis 1.0

proc APgetMOM { mData MoM rV Mass } {

   upvar $rV mV

   set toV [expr 2.0 * 1.602e-19 / $Mass]

   switch -exact -- $MoM {
      N   { set oA 6 ; set iD N }
      Vx  { set oA 7 ; set iD V }
      Vy  { set oA 8 ; set iD V }
      Vz  { set oA 9 ; set iD V }
      Ex  { set oA 10 ; set iD E }
      Ey  { set oA 13 ; set iD E }
      Ez  { set oA 15 ; set iD E }
      F1  { set oA 26 ; set iD F }
      F2  { set oA 27 ; set iD F }
      F3  { set oA 28 ; set iD F }
      F4  { set oA 29 ; set iD F }
      F5  { set oA 30 ; set iD F }
      F6  { set oA 31 ; set iD F }
      F7  { set oA 32 ; set iD F }
      F8  { set oA 33 ; set iD F }
      F9  { set oA 34 ; set iD F }
      F10 { set oA 35 ; set iD F }
      Byr { set oA 0  ; set iD TM }
      Bdy { set oA 1  ; set iD TM }
      Bms { set oA 2  ; set iD TM }
      Eyr { set oA 3  ; set iD TM }
      Edy { set oA 4  ; set iD TM }
      Ems { set oA 5  ; set iD TM }
      Txx { set oA 10 ; set oB 7 ; set oC 7 ; set iD T }
      Txy { set oA 11 ; set oB 7 ; set oC 8 ; set iD T }
      Txz { set oA 12 ; set oB 7 ; set oC 9 ; set iD T }
      Tyy { set oA 13 ; set oB 8 ; set oC 8 ; set iD T }
      Tyz { set oA 14 ; set oB 8 ; set oC 9 ; set iD T }
      Tzz { set oA 15 ; set oB 9 ; set oC 8 ; set iD T }
      Pxx { set oA 10 ; set oB 7 ; set oC 7 ; set iD P }
      Pxy { set oA 11 ; set oB 7 ; set oC 8 ; set iD P }
      Pxz { set oA 12 ; set oB 7 ; set oC 9 ; set iD P }
      Pyy { set oA 13 ; set oB 8 ; set oC 8 ; set iD P }
      Pyz { set oA 14 ; set oB 8 ; set oC 9 ; set iD P }
      Pzz { set oA 15 ; set oB 9 ; set oC 8 ; set iD P }
      Vxx { set oA 10 ; set iD VT }
      Vxy { set oA 11 ; set iD VT }
      Vxz { set oA 12 ; set iD VT }
      Vyy { set oA 13 ; set iD VT }
      Vyz { set oA 14 ; set iD VT }
      Vzz { set oA 15 ; set iD VT }
      Qxx { set oA 16 ; set oB 10 ; set oC 10 ; set oD 7; set oE 7 ; set iD Q }
      Qxy { set oA 17 ; set oB 10 ; set oC 11 ; set oD 7; set oE 8 ; set iD Q }
      Qxz { set oA 18 ; set oB 10 ; set oC 12 ; set oD 7; set oE 9 ; set iD Q }
      Qyx { set oA 19 ; set oB 13 ; set oC 11 ; set oD 8; set oE 7 ; set iD Q }
      Qyy { set oA 22 ; set oB 13 ; set oC 13 ; set oD 8; set oE 8 ; set iD Q }
      Qyz { set oA 23 ; set oB 13 ; set oC 13 ; set oD 8; set oE 8 ; set iD Q }
      Qzx { set oA 21 ; set oB 15 ; set oC 12 ; set oD 9; set oE 7 ; set iD Q }
      Qzy { set oA 24 ; set oB 15 ; set oC 14 ; set oD 9; set oE 8 ; set iD Q }
      Qzz { set oA 25 ; set oB 15 ; set oC 15 ; set oD 9; set oE 9 ; set iD Q }
      Vxxx { set oA 16 ; set iD VT }
      Vxxy { set oA 17 ; set iD VT }
      Vxxz { set oA 18 ; set iD VT }
      Vxyy { set oA 19 ; set iD VT }
      Vxyz { set oA 20 ; set iD VT }
      Vxzz { set oA 21 ; set iD VT }
      Vyyy { set oA 22 ; set iD VT }
      Vyyz { set oA 23 ; set iD VT }
      Vyzz { set oA 24 ; set iD VT }
      Vzzz { set oA 25 ; set iD VT }
   }

   set nM [llength $mData]

   set mB 1.0
   switch -exact -- $iD {
      N {
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      V {
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      VT {
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      T {
         set mB [expr 2.0 / $toV]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set Vij [lindex $V $oA]
	    set Vi  [lindex $V $oB]
	    set Vj  [lindex $V $oC]
	    set mV($I) [expr $Vij - $Vi * $Vj]
	 }
      }
      P {
         set mB $Mass
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set D [lindex $mData 6]
	    set Vij [lindex $V $oA]
	    set Vi  [lindex $V $oB]
	    set Vj  [lindex $V $oC]
	    set mV($I) [expr $D * ($Vij - $Vi * $Vj)]
	 }
      }
      Q {
         set mB [expr $Mass / 2.0]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set Viij [lindex $V $oA]
	    set Vii  [lindex $V $oB]
	    set Vij  [lindex $V $oC]
	    set Vi   [lindex $V $oD]
	    set Vj   [lindex $V $oE]
	    set mV($I) [expr $Viij - 2.0 * $Vij * $Vi - $Vii * $Vj + \
	                   $Vi * $Vi * $Vj]
	 }
      }
      E {
         set mB [expr 1.0 / $toV]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      F {
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      TM {
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $mData $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
   }

   # GET to units 

   if { $mB != 1.0 } { TUarrayMath mV * $mB mV $nM }

   return $nM
} 
