# FOR non-time based data 

#   Variables are assumed to start with _

package provide UDFAnalysis 1.0

proc APasciiNTBase { vD fd nLines rCmD rRep rAdv rLine } {
   global apANS 

   upvar $rCmD  rC
   upvar $rRep  rP
   upvar $rAdv  rI
   upvar $rLine rL

# SET up the variable array increment counters.  There is one per
#   defined line definition.

      for { set I 0 } { $I < $nLines } { incr I } { set vC($I) 0 }

# READ in the entire data file

   set _bC 0
   set EOF [gets $fd LiNe]
   set _cL [string first $apANS($vD,Comment) $LiNe]
   while { $EOF >= 0  && ($_cL == 0) } {
      set EOF [gets $fd LiNe]
      set _cL [string first $apANS($vD,Comment) $LiNe]
   }

   while { $EOF >= 0 } {
      if { $EOF > 0 } {
         for { set I 0 } { $I < $nLines } { incr I } {
            set J 0
            while { ($EOF >= 0) && ($J < $rP($I)) } {
               set _N [expr $rI($I) * $vC($I)]
               eval $rC($I)
               incr vC($I)
               incr J
               set EOF [gets $fd LiNe]
               set _cL [string first $apANS($vD,Comment) $LiNe]
               while { $EOF >= 0  && ($_cL == 0) } {
                  set EOF [gets $fd LiNe]
                  set _cL [string first $apANS($vD,Comment) $LiNe]
               }
            }
         }
	 incr _bC
      }
   }

# CLOSE the data file

   close $fd

# GET the array size.  

   set CanGrid 1
   for { set I 0 } { $I < $nLines } { incr I } {
      set aSize($I) 1
      set tSz [expr $rI($I) * $rP($I)]
      if { $tSz > $aSize($I) } { set aSize($I) $tSz }
      if { $aSize($I) > 1 } { set CanGrid 0 }
   }

# ARRAY data can't be gridded --- at least here

   if { $CanGrid } { set gData $apANS($vD,gData) } else { set gData NO }

#  GET the variable names and the elements we are to get

   set vI [APgetVNames $apANS($vD,aVar)]
   set mN [lindex $vI 0]
   set nE [llength $mN]
   set vI [APgetVNames $apANS($vD,Var)]
   set vN [lindex $vI 0]

# IF needed for gridding this is the index array.

   for { set I 0 } { $I < $_bC } { incr I } { set tMb($I) [expr $I + 0.5] }

# DETERMINE the line number each returned variable is in

   set vS ""
   for { set I 0 } { $I < $nE } { incr I } {
      set iName [lindex $mN $I]
      for { set J 0 } { $J < $nLines } { incr J } {
         set P [lsearch -exact $rL($J) $iName]
	 if { $P >= 0 } { lappend vS $J ; continue }
      }
   }

# TRANSFER the data to the assigned variables.  
 
   for { set I 0 } { $I < $nE } { incr I } {
      set Var  [lindex $vN $I]
      global [set Var]
      upvar 0 [set Var] GriD

      APkeepTabs "CREATING $Var"

      set iName [lindex $mN $I]
      set lN [lindex $vS $I]

      if [string match YES $gData] {
         APgridData $vD $_bC tMb tMb Y Y $iName GriD NorM
         set GriD(Dim) [list $GriD(gI4) 1]
      } else {
         upvar 0 $iName _TmP_

         set tV [expr $_bC * $aSize($lN)]
	 for { set J 0 } { $J < $tV } { incr J } { set GriD($J) $_TmP_($J) }
	 set GriD(Dim) [list $_bC $aSize($lN)]
      }
   }
}
