package provide UDFAnalysis 1.0

proc APaddItem { Menu } {
   global apANS Prefs 

# SET the current reference number and advance it

   set InDx $Menu,sN
   if ![info exists apANS($InDx)] { set apANS($InDx) 0 }
   set rN $apANS($InDx)
   incr apANS($InDx)


# DO any preliminary menu specific sets
#   FUNCTION and VARIABLE need to have the Function or Variable type selected
#      in order to continue

   switch -exact -- $Menu {
      FUNCTION {
         if [string match NONE $apANS(CurFunc)] { return }
         set W .apFUNC.body.list
         set apANS($rN,Func) $apANS(CurFunc)
         set apANS(CurFunc) NONE
         GUIchgConf .apFUNC.cmd.l.src SOURCE ""
      }
      GOBJ {
         if [string match NONE $apANS(gCurObj)] { return }
         set W .apGOBJ.body.list
         set apANS($rN,gObj) $apANS(gCurObj)
         set apANS(gCurObj) NONE
         GUIchgConf .apGOBJ.cmd.l.src SOURCE ""
      }
      VARIABLE {
         if [string match NONE $apANS(CurSrc)] { return }
         set W .apVAR.body.list
         set apANS($rN,Src) $apANS(CurSrc)
         set apANS(CurSrc) NONE
         GUIchgConf .apVAR.cmd.l.src SOURCE ""
      }
      default {
         set W .ap$Menu.body.list
         APxferItem $Menu FROMTMP $rN
      }
   }

# INITIALIZE the information

   APallInits $Menu $rN

# SEE where the definition is to be put

   set Ln [lindex [split [$W curselection]] 0]
   if { [string length $Ln] == 0 } { set Ln end }

# FORM the text window format and then the line identifying this description

   set nL [APtwinLab $Menu $rN LaB]

# OUTPUT the description to the text box, clear the selected entry and make
#   sure its visible

   $W selection clear $Ln
   $W insert $Ln $LaB(0)
   $W see $Ln
}
