# FIT as set of data to the a pair of gaussians of the form:
#
#           Y = A * exp(-(X - B)/C)^2) + D * exp(-(X - E)/F)^2)
#
# THE function returns Y, dY/dA, dY/dB, dY/dC, dY/dD, dY/dE and dY/dF 
#     for any X.

package provide UDFAnalysis 1.0

proc AP2gaussFunc { nA dYdA Ops } {
    global _X_

    upvar $dYdA dA
    upvar $Ops  oP

    set xV $_X_($oP(4))

# THE coefficients

    set A $oP(5) ; set B $oP(6) ; set C $oP(7)
    set D $oP(8) ; set E $oP(9) ; set F $oP(10)

# FIRST gaussian parameters

    set xSa [expr ($xV - $B) / $C]
    set ExPa [expr exp(-$xSa * $xSa)]
    set Ta [expr $A * $ExPa  * 2.0 * $xSa]

# SECOND gaussian parameters

    set xSb [expr ($xV - $E) / $F]
    set ExPb [expr exp(-$xSb * $xSb)]
    set Tb [expr $D * $ExPb  * 2.0 * $xSb]

# THE value of the function

    set yV [expr $A * $ExPa + $D * $ExPb]

# Derivitive with respect to A is exp(-(X - B)/C)^2)
# Derivitive with respect to D is exp(-(X - E)/F)^2)

    set dA(0) $ExPa
    set dA(3) $ExPb

# Derivitive with respect to B is (2.0 * A * xSa * ExPa)/C
# Derivitive with respect to E is (2.0 * D * xSb * ExPb)/F

    set dA(1) [expr $Ta / $C]
    set dA(4) [expr $Tb / $F]

# Derivitive with respect to C is (2.0 * A * xSa * xSa * ExPa)/C 
# Derivitive with respect to F is (2.0 * D * xSb * xSb * ExPb)/F 

    set dA(2) [expr $Ta * $xSa / $C]
    set dA(5) [expr $Tb * $xSb / $F]

    return $yV
}
