package provide UDFAnalysis 1.0

# Multiplies one or more variables by a constant

proc APsolveVec { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {
       APkeepTabs "STEP $fD : VECTOR ($I)"

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s" _Va _Op _Vb _OuT

# GET the input A vector variable list

      set rV [APgetVNames $_Va]
      set aNames [lindex $rV 0]
      set nA [llength $aNames]

# GET the input B vector variable list

      if ![string match $apANS(EmptyVar) $_Vb] {
         set rV [APgetVNames $_Vb]
         set bNames [lindex $rV 0]
         set nB [llength $bNames]
      } else { set nB 0 }

# GET the output output variable list

      set rV [APgetVNames $_OuT]
      set cNames [lindex $rV 0]
      set nC [llength $cNames]

# AND the operation

      switch -exact -- $_Op {
         ANGLE     { set nO 1 ; set nI 2 }
         CROSS     { set nO 3 ; set nI 2 }
         DISTANCE  { set nO 1 ; set nI 2 }
         DOT       { set nO 1 ; set nI 2 }
         MAGNITUDE { set nO 1 ; set nI 1 }
         RECTOSPH  { set nO 3 ; set nI 1 }
         SPHTOREC  { set nO 3 ; set nI 1 }
         UNIT      { set nO 3 ; set nI 1 }
	 PARAPERP  { set nO 2 ; set nI 1 }
      }


      set IvA [list VaX VaY VaZ] 
      set IvB [list VbX VbY VbZ] 
      set OvC [list VcX VcY VcZ] 

# GET the input vector A components

      for { set J 0 } { $J < $nA } { incr J } {
         set vR [lindex $aNames $J]
         global [set vR]
         upvar 0 [set vR] [lindex $IvA $J] 
	 if { $J == 0 } { set nE [lindex $VaX(Dim)  0] }
      }

# IF we need a second vector to operate on then get that

      if { $nI == 2 } {
         for { set J 0 } { $J < $nB } { incr J } {
            set vR [lindex $bNames $J]
            global [set vR]
            upvar 0 [set vR] [lindex $IvB $J] 
         }
      }

# GET the output variable(s)

      for { set J 0 } { $J < $nC } { incr J } {
         set vR [lindex $cNames $J]
         global [set vR]
         upvar 0 [set vR] [lindex $OvC $J] 
	 upvar 0 [lindex $OvC $J] _TmP_
         set _TmP_(Dim) [list $nE 1]
	 APxferGInfo VaX _TmP_
      }

# Vector Operators:
#
#   ANGLE - find the angle between two vectors

      switch -exact -- $_Op {
         ANGLE {
            APbadGrid FLAG $nE VaX Status
            APbadGrid AFLAG $nE VbX Status
	    TUarrayMath VaX * VbX  Sx $nE 
	    TUarrayMath VaY * VbY  Sy $nE 
	    TUarrayMath VaZ * VbZ  Sz $nE 
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz Sang $nE
	    TUarrayMath VaX * VaX  Sx $nE 
	    TUarrayMath VaY * VaY  Sy $nE 
	    TUarrayMath VaZ * VaZ  Sz $nE 
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz SaU $nE
            TUarrayMath SaU SQRT SaU SaU $nE
	    TUarrayMath VbX * VbX  Sx $nE 
	    TUarrayMath VbY * VbY  Sy $nE 
	    TUarrayMath VbZ * VbZ  Sz $nE 
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz SbU $nE
            TUarrayMath SbU SQRT SbU SbU $nE
            TUarrayMath Sang / SaU Sang  $nE
            TUarrayMath Sang / SbU Sang  $nE
            TUarrayMath Sang ACOSD Sang VcX $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
         } 
         CROSS {
            APbadGrid FLAG $nE VaX Status
            APbadGrid AFLAG $nE VbX Status
	    TUarrayMath VaY * VbZ  Sa $nE 
	    TUarrayMath VaZ * VbY  Sb $nE 
            TUarrayMath Sa - Sb VcX $nE
	    TUarrayMath VaZ * VbX  Sa $nE 
	    TUarrayMath VaX * VbZ  Sb $nE 
            TUarrayMath Sa - Sb VcY $nE
	    TUarrayMath VaX * VbY  Sa $nE 
	    TUarrayMath VaY * VbX  Sb $nE 
            TUarrayMath Sa - Sb VcZ $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcY Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcZ Status 0 $apANS(BaD)
         } 
         DISTANCE {
            APbadGrid FLAG $nE VaX Status
            APbadGrid AFLAG $nE VbX Status
	    TUarrayMath VaX - VbX  Sx $nE 
	    TUarrayMath VaY - VbY  Sy $nE 
	    TUarrayMath VaZ - VbZ  Sz $nE 
            TUarrayMath Sx * Sx  Sx $nE
            TUarrayMath Sy * Sy  Sy $nE
            TUarrayMath Sz * Sz  Sz $nE
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz VcX $nE
            TUarrayMath VcX SQRT VcX VcX $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
	 }
         DOT {
            APbadGrid FLAG $nE VaX Status
            APbadGrid AFLAG $nE VbX Status
	    TUarrayMath VaX * VbX  Sx $nE 
	    TUarrayMath VaY * VbY  Sy $nE 
	    TUarrayMath VaZ * VbZ  Sz $nE 
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz VcX $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
         } 
         MAGNITUDE {
            APbadGrid FLAG $nE VaX Status
            TUarrayMath VaX * VaX  Sx $nE
            TUarrayMath VaY * VaY  Sy $nE
            TUarrayMath VaZ * VaZ  Sz $nE
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz VcX $nE
            TUarrayMath VcX SQRT VcX VcX $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
	 }
         PARAPERP {
            APbadGrid FLAG $nE VaX Status
	    for { set J 0 } { $J < $nE } { incr J } { set VcX($J) $VaX($J) }
            TUarrayMath VaY * VaY  Sy $nE
            TUarrayMath VaZ * VaZ  Sz $nE
            TUarrayMath Sy + Sz  VcY $nE
            TUarrayMath VcY SQRT VcY VcY $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcY Status 0 $apANS(BaD)
         }
         RECTOSPH {
            APbadGrid FLAG $nE VaX Status
            TUarrayMath VaX * VaX  Sx $nE
            TUarrayMath VaY * VaY  Sy $nE
            TUarrayMath VaZ * VaZ  Sz $nE
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy SQRT Sy Mxy $nE
            TUarrayMath Sxy + Sz VcX $nE
            TUarrayMath VcX SQRT VcX VcX $nE
            TUarrayMath VaX ATAND VaY VcY $nE
            TUarrayMath VaZ ATAND Mxy VcZ $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcY Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcZ Status 0 $apANS(BaD)
         }
         SPHTOREC {
            APbadGrid FLAG $nE VaX Status
            TUarrayMath VaY SIND VaY Sp $nE
            TUarrayMath VaY COSD VaY Cp $nE
            TUarrayMath VaZ SIND VaZ St $nE
            TUarrayMath VaZ COSD VaZ Ct $nE
            TUarrayMath Cp * St Xc $nE
            TUarrayMath Sp * St Yc $nE
            TUarrayMath Xc * VaX VcX $nE
            TUarrayMath Yc * VaX VcY $nE
            TUarrayMath Ct * VaX VcZ $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcY Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcZ Status 0 $apANS(BaD)
         }
         UNIT {
            APbadGrid FLAG $nE VaX Status
            TUarrayMath VaX * VaX  Sx $nE
            TUarrayMath VaY * VaY  Sy $nE
            TUarrayMath VaZ * VaZ  Sz $nE
            TUarrayMath Sx + Sy  Sxy $nE
            TUarrayMath Sxy + Sz Vm $nE
            TUarrayMath Vm SQRT Vm Vm $nE
            TUarrayMath VaX / Vm  VcX $nE
            TUarrayMath VaY / Vm  VcY $nE
            TUarrayMath VaZ / Vm  VcZ $nE
            APbadGrid RESET $nE VcX Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcY Status 0 $apANS(BaD)
            APbadGrid RESET $nE VcZ Status 0 $apANS(BaD)
	 }
      }
   }
}
