package provide UDFAnalysis 1.0

# Rotates one vector into the coordinates of a target vector. The new X
#  component will be parallel to the target vector and Y and Z perpendicular
#  to it.

proc APsolveRot { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : ROTATION"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# GROUP sets of definitions which use a common target vector 

   set Starts ""
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s" _iV _tV _Rev _oV
      if ![string match $apANS(EmptyVar) $_tV] { lappend Starts $I }
   }

# LOOP over the groups

   set nS [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nS } { incr G } {

      if { $G != $nS } {
         set EnD [lindex $Starts [expr $G + 1]]
      } else { set EnD $nF }
      set BeG [lindex $Starts $G]

# Process each definition

      for { set I $BeG } { $I < $EnD } { incr I } {

# GET the first line
   
         set LiNe [$W get $I]

# BREAK it apart

         scan $LiNe "%s %s %s %s" _iV _RoP _tV _oV

# Setup the input, target, and output vectors.  Only need to set up the 
#   target variable if this is the first definition in a group.

         if ![string match $apANS(EmptyVar) $_tV] { 
            set tNames [lindex  [APgetVNames $_tV] 0]
            set nV [llength $tNames]
	    if { $nV != 3 } { 
	        puts stderr "ROTATION - Target not Vector" 
		exit
            }

            set vR [lindex $tNames 0] ; global [set vR] ; upvar 0 [set vR] _Tx
            set vR [lindex $tNames 1] ; global [set vR] ; upvar 0 [set vR] _Ty
            set vR [lindex $tNames 2] ; global [set vR] ; upvar 0 [set vR] _Tz
         }

         set iNames [lindex  [APgetVNames $_iV] 0]
         set nV [llength $iNames]
	 if { $nV != 3 } { 
	     puts stderr "ROTATION - Input not Vector" 
             exit	
         }

         set vR [lindex $iNames 0] ; global [set vR] ; upvar 0 [set vR] _Ix
         set vR [lindex $iNames 1] ; global [set vR] ; upvar 0 [set vR] _Iy
         set vR [lindex $iNames 2] ; global [set vR] ; upvar 0 [set vR] _Iz
         set nE [lindex $_Ix(Dim) 0]

         set oNames [lindex  [APgetVNames $_oV] 0]
         set nV [llength $oNames]
	 if { $nV != 3 } { 
	     puts stderr "ROTATION - Output not Vector" 
             exit	
         }

         set vR [lindex $oNames 0] ; global [set vR] ; upvar 0 [set vR] _Ox
         set vR [lindex $oNames 1] ; global [set vR] ; upvar 0 [set vR] _Oy
         set vR [lindex $oNames 2] ; global [set vR] ; upvar 0 [set vR] _Oz

         set _Ox(Dim) [list $nE 1]
         set _Oy(Dim) [list $nE 1]
         set _Oz(Dim) [list $nE 1]
	 APxferGInfo _Ix _Ox
	 APxferGInfo _Ix _Oy
	 APxferGInfo _Ix _Oz

# MERGE the rotation matrices into one enormous array.  Rotation matrices
#   are different for INTO and OUTOF rotations

         APbadGrid FLAG $nE _Tx Status

	 TUarrayMath _Tx * _Tx _TmPx $nE
	 TUarrayMath _Ty * _Ty _TmPy $nE
	 TUarrayMath _TmPx + _TmPy _Txy $nE
	 TUarrayMath _Txy SQRT _Txy _Txy $nE
	 TUarrayMath _Tx ATAND _Ty _Tp $nE
	 TUarrayMath _Txy ATAND _Tz _Tt $nE
	 unset _Txy ; unset _TmPx ; unset _TmPy

	 if [string match OUTOF $_RoP] {
            for { set K 0; set L 0 } { $K < $nE } { incr K } {
	       TUmatrixRot $_Tp($K) 0. 0. rZ Z
	       TUmatrixRot $_Tt($K) 0. 0. rY Y
	       set Off [expr $K * 9]
	       TUmatrixMath rY * rZ rF 3 3 3 3 
	       TUmatrixMath rF TRANSPOSE rF rM 3 3 3 3 0 0 $Off
	    }
         } else { 
            for { set K 0; set L 0 } { $K < $nE } { incr K } {
	       TUmatrixRot $_Tp($K) 0. 0. rZ Z
	       TUmatrixRot $_Tt($K) 0. 0. rY Y
	       set Off [expr $K * 9]
	       TUmatrixMath rY * rZ rM 3 3 3 3 0 0 $Off
	    }
         }

# NOW do the rotations. 

         for { set K 0; } { $K < $nE } { incr K } {
	    set Off [expr $K * 9]
	    set tI(0) $_Ix($K) ; set tI(1) $_Iy($K) ; set tI(2) $_Iz($K)
	    TUmatrixMath rM * tI tO 3 3 3 1 $Off 0 0
	    set _Ox($K) $tO(0) ; set _Oy($K) $tO(1) ; set _Oz($K) $tO(2)
         }

	 APbadGrid RESET $nE _Ox Status 0 $apANS(BaD)
	 APbadGrid RESET $nE _Oy Status 0 $apANS(BaD)
	 APbadGrid RESET $nE _Oz Status 0 $apANS(BaD)
      }
   }
}
