package provide UDFAnalysis 1.0

# THIS procedure removes spikes from a GRIDDED data set. The data set is
#   split into a number of intervals of nP points with the last interval
#   taking on all left over points. The standard deviation in each interval
#   is computed and all points larger than mSig are removed. There is 
#   one further iteration will all of the removed data excluded. The removed
#   data can be filled or not.
 

proc APsolveRmSpike { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : RMSPIKE"

# THIS is the text window for this function definition
 
       
   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }
       
# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line

      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s %s %s %s" \
                   _vI _vO _vS _mSig _nP _nS _iFmt _C _lT _gT _fI

# GET the input variable list

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]

# CHECK to see if we need to form a Status Array
 
      if ![string match $apANS(EmptyVar) $_vS] {
         set rV [APgetVNames $_vS]
         set sNames [lindex $rV 0]
         set nS [llength $sNames]
      } else { set nS 0 }

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]
      set nO [llength $oNames]

# HOW many points in a processing interval and how many point to slide it
 
      if { $_nS <= 0 } { set _nS 1 }
      if { $_nS > $_nP } { set _nS $_nP}
      if [string match TIME $_iFmt] {
         set _niP [expr int($_nP / $apANS(CellSz))]
         set _niS [expr int($_nS / $apANS(CellSz))]
      } else { set _niP $_nP ; set _niS $_nS }

# LOOP over the variables
 
      for { set J 0 } { $J <  $nI } { incr J } {

         set vR [lindex $iNames $J]
	 global [set vR]
	 upvar 0 [set vR] _In
         set _nE [lindex $_In(Dim) 0]

# GET the grid info array
 
         if ![info exist _In(gInE)] {
	    puts stderr "APsolveRmSpk -- $vR is not a gridded variable"
	    exit
	 } else { APxferGInfo  _In gI DATA REVERSE }

#CHECK for STATUS array and initialize if there is one
 
         if { $nS > 0 } {
            set vR [lindex $sNames $J]
	    global [set vR]
	    upvar 0 [set vR] _sA
	    APxferGInfo gI _sA GI
	    set _sA(Dim) $_In(Dim)
         }

# SET up mask to exclude all specified data

	 APbadGrid $_C $_nE _In _sA 0 $_lT $_gT

         set vR [lindex $oNames $J]
         global [set vR]
         upvar 0 [set vR] _Out
	 set _Out(Dim) $_In(Dim)
	 APxferGInfo gI _Out GI

# LOOP over the intervals
 
         set _EnD 0
	 set cB 0
         while { $_EnD < $_nE } {

# SET the interval start and stop locations
 
	    set _BeG $cB
	    set _EnD [expr $_BeG + $_nP]
	    set T1 [expr $_EnD + $_nS]
	    if { $T1 > $_nE } { 
	       set _EnD $_nE 
	       set DoOnce 0
            } else { set DoOnce 1 }

# ITERATE until no points exist above bounds
 
	    set KnB 0
	    set GoOn 1
            while { $GoOn } {

# GET the interval of data being worked on

               set nD 0
	       if $DoOnce {
		  set  L $_BeG
	          while { ($L < $_nE ) && ($nD < $_nP) } {
                     if { $_sA($L) } {
 	                set _TmP($nD) $_In($L)
                        incr nD
                     } 
		     incr L
                  }
		  if { $L >= $_nE } { 
		      set _EnD $_nE
                  } else { set _EnD [expr $L + 1] }
		  set DoOnce 0
               } else {
                  for { set L $_BeG } { $L <  $_EnD } { incr L } {
                     if { $_sA($L) } {
    	                set _TmP($nD) $_In($L)
                        incr nD
                     }
                  }
               }

# FORM the stand variation of the points 
 
               set AvG [TUarrayMath _TmP AVG _TmP _TmP $nD]
	       set VaR [TUarrayMath _TmP VAR $AvG _TmP $nD]
	       set SiG [expr sqrt($VaR)]

# SET to bad any point above maximum sigma 
 
               set nB 0
               set dRm [expr $_mSig * $SiG]
	       for { set L $_BeG } { $L <  $_EnD } { incr L } {
	          set dV [expr abs($_In($L) - $AvG)]
	          if { $dV >= $dRm } { set _sA($L) 0 ; incr nB }
	       }

               if { $nB != $KnB } { set KnB $nB } else { set GoOn 0 }
            }

	    incr cB $_nS
	 }

# Mask out all the bad data and fill in the holes if needed
 
         for { set K 0 } { $K < $_nE } { incr K } { set _Out($K) $_In($K) }
         APbadGrid RESET $_nE _Out _sA 0 gI(11) 
         if { [string match YES $_fI] } { TUgridFill1D _Out gI X LI -1 1 }
      }
   }
}
