package provide UDFAnalysis 1.0

# Print data to a file
#
# THE way this module is setup makes processing it a bit of a pain.  The
#   first definition must have a file name to output to.  Succeeding lines
#   with a blank file name have their variables output in the last named
#   file.

proc APsolvePrint { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : PRINT"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances to see how to group definitions

   set Starts ""
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s" _fN _tM _FmT _vO
      if ![string match "---"  $_fN] { lappend Starts $I }
   }

# LOOP over the groups

   set nG [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nG } { incr G } {

      if { $G != $nG } {
         set EnD [lindex $Starts [expr $G + 1]]
      } else { set EnD $nF }
      set BeG [lindex $Starts $G]

      set fList ""
      set vList ""
      set iList ""

      for { set I $BeG } { $I < $EnD } { incr I } {

# GET the first line
   
         set LiNe [$W get $I]

# BREAK it apart

         scan $LiNe "%s %s %s %s" _fN _tM _FmT _vO

# OPEN the output file if this first read for this block

         if { $I == $BeG } {
            if [catch { open $_fN w } fo ] {
               puts stderr "ERROR ... CANNOT OPEN $_fN\n"
               return
            }          
	    set tD $_tM
         }

# START building a list of variables and formats.  Need to be cognizant that
#    some variables may be array elements.  These variables have a "(" in
#    them

         set Op [string first "(" $_vO]
	 if { $Op >= 0 } {
	     set Cp [string first ")" $_vO]
	     set _vOt  [string range $_vO 0 [expr $Op - 1]]
	     set _Ix [string range $_vO [expr $Op + 1] [expr $Cp -1]]
	 } else {
	     set _vOt $_vO
	     set _Ix ""
         }         

         if [string match apANS $_vOt] { 
            lappend vList $_vOt
            lappend fList $_FmT
            lappend iList $_Ix
         } else {
            set rV [APgetVNames $_vOt]
            set vNames [lindex $rV 0]
            set nI [llength $vNames]

	    for { set J 0 } { $J < $nI } { incr J } { 
               lappend vList [lindex $vNames $J]
               lappend fList $_FmT
               lappend iList $_Ix
            }
         }
      }

# NOW have the formats and the variables.  Get the variables into named
#   arrays and make sure they are all the same length.

      set lenOK 1
      set vLen 0
      set nV [llength $vList]

      set vR [lindex $vList 0]
      global [set vR] ; upvar 0 [set vR] _V0 ; upvar 0 _V0 pV

      if { [string length [lindex $iList 0]] > 0 } { 
         set vLen 1
      } elseif { [lindex $pV(Dim) 1] > 1 } { 
         set vLen [lindex $pV(Dim) 1]
      } else { set vLen [lindex $pV(Dim) 0] }
      APxferGInfo _V0 gI DATA REVERSE

      for { set J 1 } { $J < $nV } { incr J } {
         set vR [lindex $vList $J]
         global [set vR] ; upvar 0 [set vR] _V$J ; upvar 0 _V$J pV
	 if { [string length [lindex $iList $J]] > 0 } { 
	    set nLen 1
         } elseif { [lindex $pV(Dim) 1] > 1 } { 
	    set nLen [lindex $pV(Dim) 1]
	 } else { set nLen [lindex $pV(Dim) 0] }
         if { $vLen != $nLen } { set lenOK 0 }
      }

# NUKE the print if all of the variables don't have the same length

      if !$lenOK {
         puts $fo "VARIABLES HAVE MISMATCHED LENGTHS"
         close $fo
         return;
      }

# PRINT some header information.

      puts $fo "UDFANALYSIS GENERATED DUMP FILE"
      puts $fo "MENU:       $apANS(miFile)"
      puts $fo "VARIABLES:" 
      if [string match YES $apANS($fD,prTm)] {
         puts $fo "  POS 0 :  START TIME"
         puts $fo "  POS 1 :  STOP TIME"
         set K 2
      } else {
         puts $fo "  POS 0 :  ARRAY INDEX"
         set K 1
      }

      for { set J 0 } { $J < $nV } { incr J ; incr K } {
	 if { [string length [lindex $iList $J]] > 0 } { 
             puts $fo "  POS $K :  [lindex $vList $J]([lindex $iList $J])"
         } else { puts $fo "  POS $K :  [lindex $vList $J]" }
      }

      if [string match YES $apANS($fD,prTm)] {

# GET the start and stop time.  We assume that the variable have all been
#   gridded to a common grid so get that gird information and make the
#   time from it.

         set bT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
         set B 1

         TUgridInfo 30 gI T

         puts $fo BEGIN

         for { set J 0; set K 1 } { $J < $gI(4) } { incr J ; incr K } {
            set Tm [TUtimeConv $bT $T($J) 2 B]
	    set Yr [lindex $Tm 0] ; set Dy [lindex $Tm 1]
            set Ms [lindex $Tm 2] ; set Ns [lindex $Tm 3]
	    set T1 [TUtimeFmt 0 $Yr $Dy $Ms $Ns]

            set Tm [TUtimeConv $bT $T($K) 2 B]
	    set Yr [lindex $Tm 0] ; set Dy [lindex $Tm 1]
            set Ms [lindex $Tm 2] ; set Ns [lindex $Tm 3]
            set T2 [TUtimeFmt 0 $Yr $Dy $Ms $Ns]

            puts -nonewline $fo "$T1 $T2"
            for { set L 0 } { $L < $nV } { incr L } {
	        upvar 0 _V$L pV
                puts -nonewline $fo " [format [lindex $fList $L]  $pV($J)]" 
	    }
            puts $fo "" 
         }
      } else {
         puts $fo BEGIN

         for { set J 0 } { $J < $vLen } { incr J } {
            puts -nonewline $fo "[format "%6d" $J] "
            for { set K 0 } { $K < $nV } { incr K } {
                upvar 0 _V$K pV
	        if { [string length [lindex $iList $K]] > 0 } { 
	           if [string match apANS [lindex $vList $K]] {
		      set _T \$apANS\([lindex $iList $K]\)
		   } else { set _T \$pV\([lindex $iList $K]\) } 
		} else { set _T \$pV\($J\) }
                puts -nonewline $fo " [eval format [lindex $fList $K]  $_T]" 
             }
             puts $fo "" 
         }
      }

      close $fo
   }
}
