package provide UDFAnalysis 1.0

proc APsolveMEM { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : MEM"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nFc [$W index end]

# THIS is the time step in sec
 
#  set dT $apANS(CellSz)

# NO instances then return

   if { $nFc == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nFc } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s %s %s" \
                                    _vI _pW _fQ _C _bF _eF _nFq _fSp _Pd _Rt

# CHECK for empty _C field 
 
      if [string match $apANS(EmptyVar) $_C] { set _C 0 }

# GET the input variable list

      set iNames [lindex [APgetVNames $_vI] 0 ]
      set nI [llength $iNames]

# GET the power variable list

      set pNames [lindex [APgetVNames $_pW] 0]
      set nP [llength $pNames]

# CHECK to see there are enough defined output variables.
 
     if { ($_C  <= 0) && [string match RAW $_Rt] } {
        set oSkip 2
        if { [expr 2 * $nI] < $nP } { 
	   puts stderr "Too few output variables for return Raw FFT"
	   exit
        }
     } else {
        set oSkip 1
        if { $nI < $nP } { 
	   puts stderr "Too few output variables for return Power"
	   exit
        }
     }

# GET the Frequency variable list - should only be one variable so take what
#   you get

      set rV [APgetVNames $_fQ]
      set vR [lindex [lindex $rV 0] 0]
      global [set vR ]
      upvar 0 [set vR] _freQ

# IF _C is <= 0 then use FFT rather than an MEM.

     if { $_C > 0 } {

        set _freQ(Dim) [list $_nFq 1]

# FORM the frequency array.  How this is formed depends on the point spacing
#   chosen

         set nFb [expr double($_nFq) - 1.0] 
         if [string match LINEAR $_fSp] {
            set dF [expr ($_eF - $_bF) / $nFb]

            for { set J 0 } { $J < $_nFq } { incr J } {
               set _freQ($J) [expr $_bF + $J * $dF]
            }
         } else {
	    set _lbF [expr log10($_bF)]
            set dF [expr (log10($_eF) - $_lbF) / $nFb]

            for { set J 0 } { $J < $_nFq } { incr J } {
               set _freQ($J) [expr pow(10.0, $_lbF + $J * $dF)]
            }
         }

# ASSUMPTION is that there is one power variable per input variable.  All
#    have the same frequency steps

         for { set J 0 } { $J <  $nP } { incr J } {
            set vR [lindex $iNames $J]
            global [set vR]
            upvar 0 [set vR] _In
            set nE [lindex $_In(Dim) 0]

	    set dT $_In(gIcZ)

            set vR [lindex $pNames $J]
            global [set vR]
            upvar 0 [set vR] _PwR
            set _PwR(Dim) [list $_nFq 1]

            APbadGrid FLAG $nE _In Status
            APfillHoles $nE _In LI

            set MsD [MaxEntCoef _In $nE $_C _CoeF]

            for { set K 0 } { $K < $_nFq } { incr K } {
               set FdT [expr $_freQ($K) * $dT]
	       set _PwR($K) [MaxEntPwr _CoeF $_C $FdT $MsD]
            }
	    set _PwR(Tt) [expr $dT * double($nE)]
            APbadGrid RESET $nE _In Status 0 $apANS(BaD)
         }
      } else {
#                                       FFT
#
# GET the number of elements in the input variables.

         set vR [lindex $iNames 0]
         global [set vR] ; upvar 0 [set vR] _In
         set nE [lindex $_In(Dim) 0]
	 set dT $_In(gIcZ)

# PAD or set the data to an even binary boundary
 
         set PaD 1
	 while { $PaD <= $nE } { set PaD [expr $PaD << 1] }
	 if [string match NO $_Pd] {
	    if { $PaD > $nE } { set PaD [expr $PaD >> 1] }
	    set Tt [expr $dT * double($PaD)]
	 } else { set Tt [expr $dT * double($nE)] }

# FORM the frequency array.
 
	 set dF [expr 1.0 / $dT / double($PaD)]
         set nF [expr $PaD / 2]
         for { set J 0 } { $J < $nF } { incr J } { 
	    set _freQ($J) [expr $J * $dF]
         }
         set _freQ(Dim) [list $nF 1]

# ASSUMPTION is that there is one power variable per input variable.  All
#    have the same frequency steps

         for { set J 0 } { $J <  $nI } { incr J } {
            set vR [lindex $iNames $J]
            global [set vR]
            upvar 0 [set vR] _In

            set OfF [expr $J * $oSkip]
            set vR [lindex $pNames $OfF]
            global [set vR] ; upvar 0 [set vR] _PwR
            set _PwR(Dim) [list $nF 1]
	    set _PwR(dF) $dF
	    set _PwR(Tt) $Tt
	    if { $oSkip == 2 } {
	       incr OfF
               set vR [lindex $pNames $OfF]
               global [set vR] ; upvar 0 [set vR] _PwRa
               set _PwRa(Dim) [list $nF 1]
            }

# FORM the array the FFT is based on
 
	    for { set L 0 } { $L < $nE } { incr L } { set _pD($L) $_In($L) }
	    for { set L $nE } { $L < $PaD } { incr L } { set _pD($L) 0.0 }

            APfillHoles $PaD _pD LI

            RealFfT _pD $PaD 1

            if [string match POWER $_Rt] {
               set NrM [expr 1.0 / double($nE)]
               for { set M 0 ; set N 0 } { $M < $nF } { incr M ; incr N } { 
	          set T1 [expr $_pD($N) * $_pD($N)] ; incr N
	          set T2 [expr $_pD($N) * $_pD($N)]
                  set _PwR($M) [expr ($T1 + $T2) * $NrM]
               }
            } else {
               for { set M 0 ; set N 0 } { $M < $nF } { incr M ; incr N } { 
	          set _PwR($M)  $_pD($N) ; incr N
	          set _PwRa($M) $_pD($N)
               }
	    }
         }
      }
   }
}
