package provide UDFAnalysis 1.0

# Creates an Index array either on its own or based on an input variable.
#   The input variable, when present, is assumed to be an array of grid
#   edges which starts with the lower edge of the first grid and ends with
#   the upper edge of the last grid. If there are 4 elements in the variable 
#   then these are assumed to represent 3 grids.
#   The options are:
#
#   If there is no input variable the grid is assumed to contain _nE grid
#   cells with the lower edge of the first cell being _Beg and the upper
#   edge of the last cell being _End.
#
#   Index - returns an index as .5, 1.5, 2.5 ...  with one value for each 
#           grid. (One less value than the number of elements in the input
#           array or equal to _nE if none.)
#   Center - assumes each input element is a grid edge and returns the center
#            value between the two. (One less value than the number 
#            of elements in the input array or equal to _nE if none.)
#   Width - returns the width between the centers of adjacent grid cells.
#           There are phantom cells placed before the first cell and after
#           the last so that there is one width per cell edge.
#   Distance - returns the distance across each cell. (One less value than 
#              the number of elements in the input array or equal to _nE 
#              if none.)
#   Lower Edge - returns the lower cell edges ASSUMING that the variable
#                elements are cell centers!  
#   Upper Edge - returns the upper cell edges ASSUMING that the variable
#                elements are cell centers!  
#   All Edges  - returns all the cell edges ASSUMING that the variable
#                elements are cell centers! (There is one more variable
#                returned than variable elements and if no variable then
#                there is _nE + 1 variables returned.

proc APsolveIndex { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s" _vI _vO _Ret _Beg _End _nE

# GET the input variable list

      if ![string match _NONE_ $_vI] {
         set rV [APgetVNames $_vI]
         set iN [lindex $rV 0]
         set nI [llength $iN]
      } else { set nI 0 }

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oN [lindex $rV 0]
      set nO [llength $oN]

# Create the output arrays.  This is split between definitions which do not
#   specify an input array and those that do.
 
      if { $nI > 0 } {
         for { set J 0 } { $J <  $nI } { incr J } {
            set vR [lindex $iN $J] ; global [set vR] ; upvar 0 [set vR] _In
	    set nP [lindex $_In(Dim) 1]
	    if { $nP == 1 } { set nP [lindex $_In(Dim) 0] }

            set vR [lindex $oN $J] ; global [set vR] ; upvar 0 [set vR] _Out
            set _Out(Dim) [list $nP 1]
            APxferGInfo _In _Out
 
            switch -exact -- $_Ret {
               Index {
                  for { set K 0 } { $K <  $nP } { incr K } { 
	             set _Out($K) [expr $K + 0.5] 
	          }
	       }

               Center {
	          set L 1
                  for { set K 0 } { $L <  $nP } { incr K ; incr L } { 
	             set _out($K) [expr ($_In($L) + $_In($K))/2.0]
		     set cL $cU
	          }
               }

	       Width {
	          set cL [expr ($_In(1) - $_In(0))/2.0]
		  set L 1
                  for { set K 0 } { $L <  $nP } { incr K ; incr L } { 
	             set cU [expr ($_In($L) - $_In($K))/2.0]
	             set _Out($K) [expr abs($cL + $cU)] 
		     set cL $cU
	          }
	          set _Out($K) [expr abs($cL + $cU)] 
	       }

	       Distance {
	          set L 1
                  for { set K 0 } { $L <  $nP } { incr K ; incr L } { 
	             set _out($K) [expr $_In($L) - $_In($K)]
		     set cL $cU
	          }
               }

	       Lower-Edge {
	          set L 1
                  for { set K 0 } { $L <  $nP } { incr K ; incr L } { 
	             set dW [expr ($_In($L) - $_In($K))/2.0]
	             set _Out($K) [expr $_In($K) - $dW]
	          }
	          set _Out($K) [expr $_In($K) - $dW]
	       }

	       Upper-Edge {
	          set L 1
                  for { set K 0 } { $L <  $nP } { incr K ; incr L } { 
	             set dW [expr ($_In($L) - $_In($K))/2.0]
	             set _Out($K) [expr $_In($K) + $dW]
	          }
	          set _Out($K) [expr $_In($K) + $dW]
               }

	       All-Edges {
	          set L 1
                  for { set K 0 } { $L <  $nP } { incr K ; incr L } { 
	             set dW [expr ($_In($L) - $_In($K))/2.0]
	             set _Out($K) [expr $_In($K) - $dW]
	          }
	          set _Out($K) [expr $_In($K) - $dW] 
	          set Up [expr $_In($K) + $dW] 
		  incr K
		  set _Out($K) $Up
	       }
            }
         }
      } else {
         for { set J 0 } { $J <  $nO } { incr J } {
	    set nP $_nE
            set vR [lindex $oN $J] ; global [set vR] ; upvar 0 [set vR] _Out
            set _Out(Dim) [list $nP 1]

            set Width  [expr ($_End - $_Beg) / double($_nE)]
            set hWidth [expr $Width / 2.0]

            switch -exact -- $_Ret {
               Index  -
               Center {
                  for { set K 0 } { $K <  $nP } { incr K } { 
	             set _Out($K) [expr $_Beg + $Width * $K + $hWidth] 
	          }
               }

	       Width {
                  for { set K 0 } { $L <=  $nP } { incr K } { 
	             set _Out($K) $Width 
                  }
	       }

	       Distance {
                  for { set K 0 } { $L <  $nP } { incr K } { 
	             set _Out($K) $Width 
                  }
               }

	       Lower-Edge {
                  set Width  [expr ($_End - $_Beg) / double($_nE - 1)]
                  set hWidth [expr $Width / 2.0]
                  for { set K 0 } { $K <  $nP } { incr K } { 
	             set _Out($K) [expr $_Beg - $Width * ($K + 1)] 
	          }
	       }

	       Upper-Edge {
                  set Width  [expr ($_End - $_Beg) / double($_nE - 1)]
                  set hWidth [expr $Width / 2.0]
                  for { set K 0 } { $K <  $nP } { incr K } { 
	             set _Out($K) [expr $_Beg + $Width * ($K + 1)] 
	          }
               }
	       All-Edges {
                  set Width  [expr ($_End - $_Beg) / double($_nE - 1)]
                  set hWidth [expr $Width / 2.0]
                  for { set K 0 } { $K <=  $nP } { incr K } { 
	             set _Out($K) [expr $_Beg - $Width * ($K + 1)] 
	          }
	       }
            }
         } 
      }
   }
}
