package provide UDFAnalysis 1.0

# Draws a line in one of the plots  

proc APsolveGBox { gD } {
   global apANS env Prefs WinInfo PltInfo GphInfo

   APkeepTabs "OBJECT $gD : LINE"

# THIS is the text window for this function definition

   set W .apGOBJ$gD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($gD,gObj)) 0]
      eval $GuI $gD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s" pID X(0) X(1) Y(0) Y(1) bC bF bW

# FROM the plot iD get the plot number, window number and the index into 
#   the plot definitions where the plot information is contained.

      set pS [lindex $apANS($pID) 0]
      set pN $apANS($pS,Col).$apANS($pS,Row)
      set wN $PltInfo($pN,wN)

# GET the X inputs into proper units.  X1 is either SPAN if we span the plot
# in X or a value. X2 has the option of being X1 if it is the same as X1.

      if [string match X1 $X(1)] { set X(1) $X(0) }

# IF this is a time based plot we need to convert the X inputs which should
#   be in the format YYYY DOY HH MM SS.FSEC to a proper X value

      if [string match YES $apANS($pS,tBased)] {
	 set pB [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
         if [string match SPAN $X(0)] { 
	    set xB [list $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs) ]
         } else {
            set T [split $X(0) ":"]
	    set H [lindex $T 2] ; set M [lindex $T 3] ; set S [lindex $T 4]
	    set xS [expr 3600 * $H + 60 * $M + $S]
	    set xMs [expr int(1000 * $xS)]
	    set xB [list [lindex $T 0] [lindex $T 1] $xMs]
	 }
	 set X(0) [TUtimeConv $pB $xB 0 apANS(tBase)]
         if [string match SPAN $X(1)] { 
	    set xB [list $apANS(PendYr) $apANS(PendDy) $apANS(PendMs) ]
         } else {
            set T [split $X(1) ":"]
	    set H [lindex $T 2] ; set M [lindex $T 3] ; set S [lindex $T 4]
	    set xS [expr 3600 * $H + 60 * $M + $S]
	    set xMs [expr int(1000 * $xS)]
	    set xB [list [lindex $T 0] [lindex $T 1] $xMs]
	 }
	 set X(1) [TUtimeConv $pB $xB 0 apANS(tBase)]
      } else {
         if [string match X1 $X(1)] { set X(1) $X(0) }
         if [string match SPAN $X(0)] { set X(0) $WinInfo($wN,p0) }
         if [string match SPAN $X(1)] { set X(1) $WinInfo($wN,p3) }
      }

# GET the Y inputs into proper units.  Y1 is either SPAN if we span the plot
# in Y or a value. Y2 has the option of being Y1 if it is the same as Y1.

      if [string match Y1 $Y(1)] { set Y(1) $Y(0) }
      if [string match SPAN $Y(0)] { set Y(0) $WinInfo($wN,p1) }
      if [string match SPAN $Y(1)] { set Y(1) $WinInfo($wN,p4) }

      set tColor $GphInfo(lColor)
      set tWidth $GphInfo(lWidth)
      set tClip  $WinInfo($wN,Clip)

   
      WinClip $wN AT  

      GPHwinScale $wN Xp Yp Zc 1
      if [string match YES $bF] {
         PlotColor HOLD $bC $bC
         Box $wN $X(0) $Y(0) 0.0 $X(1) $Y(1) 0.0
         PlotColor HOLD $tColor OFF
      } else {
         PlotColor HOLD $bC OFF
         LineStyle $bW
         Box $wN $X(0) $Y(0) 0.0 $X(1) $Y(1) 0.0
      }

      LineStyle $tWidth
      PlotColor HOLD $tColor OFF
      WinClip $wN $tClip  
   }
}
