package provide UDFAnalysis 1.0

proc APsolveFilter { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : FILTER"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s" _vI _vO _f(0) _f(1) _sO _dO _fMsK _R

# GET what's to be returned

      set nR [string length $_R]
      if { $nR == 0 } { continue }
      for { set J 0 } { $J < $nR } { incr J } {
         set B($J) [string index $_R $J]
      }
      
# GET the input variable list

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]

      set vR [lindex $iNames 0]
      global [set vR] ; upvar 0 [set vR] _tV_

      set _tX_ [expr (double($_tV_(gI1)) - double($_tV_(gI0))) / double($_tV_(gI4))]

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]

# Frequency bounds need to be gotten depending on if they are entered in
#    constant or variable format
 
   for { set J 0 } { $J < 2 } { incr J } {
      set rV [APgetVNames $_f($J)]
      set vNames [lindex $rV 0]
      set bType  [lindex $rV 1]
      set vType  [lindex $bType 0]
      if { [lindex $bType 0] != 1 } {
         set _oP [string first "(" $_f($J)]
	 set _cP [string first ")" $_f($J)]
	 set _fn [string range $_f($J) 0 [expr $_oP - 1]]
	 set _fi [string range $_f($J) $_oP end]
	 set sNames [lindex [APgetVNames $_fn] 0]
	 set vR [lindex $sNames 0]
	 global  [set vR] ; upvar 0 [set vR] _TAr

         set _T \$$vR$_fi
         set _fQ($J) [expr $_T]
      } else { set _fQ($J) $_f($J) }
   }

# THIS is the number of samples per second

      set sPs [expr 1.0 / $_tX_]

# THIS is the SAVITSKY-GOLAY inputs for this band.  The filter length is the 
#   number of points which makes up 1/2 cycle of the lower defined band 
#   frequency.  I have no idea if this is right or not but it sounds good.
#   and seems to bear out in tests.

      set lCycLen [expr 1.0 / $_fQ(0)]
      set lH [expr int($sPs * $lCycLen / 2.0)]
      if { $lH < 2 } { 
	 puts stderr "Too Few Points in Lower Filter ($lH) - set to 2" 
         set lH 2 
      }

      set uCycLen [expr 1.0 / $_fQ(1)]
      set uH [expr int($sPs * $uCycLen / 2.0)]
      if { $uH < 2 } { 
	 puts stderr "Too Few Points in Upper Filter ($uH) - set to 2" 
         set uH 2 
      }

      set rVar 0
      if { $_fQ(0) == $_fQ(1) } { set mR 2 } else { set mR 4 }
      if { $nR > $mR } { set nR $mR }

# LOOP over the input variables

      for { set J 0 } { $J < $nI } { incr J } {

         set vR [lindex $iNames $J]
         global [set vR] ; upvar 0 [set vR] _In
	 set nX [lindex $_In(Dim) 0]
	 set nY [lindex $_In(Dim) 1]
	 if {$nY > 1 } { set nE $nY } else { set nE $nX }

# COPY the array into a temp array

         for { set K 0 } { $K < $nE } { incr K } { set _TmP($K) $_In($K) }

# GET rid of bad data - set it to 0

         APbadGrid FANDC $nE _TmP NoData 0

# THIS is the binary length we need

         set bL 1
         while { $bL < $nE } { set bL [expr $bL * 2] }

# AND pad it to binary length

         for { set K $nE } { $K < $bL } { incr K } { set _TmP($K) 0.0 }

# Different approach if the band edges match or are different.

         if { $mR == 2 } {

# IN this case work only with the upper edge so this band includes everything 
#   below uEdge and is the lower band.   

# FILTER the data to the upper cutoff

            set tC [ expr 2 * $uH + 1]
            TUsavgolCoef _C $tC $uH $uH $_dO $_sO
            FfTConvolve _TmP $bL _C $tC CONVOLVE _Hi

# Form the returns and mask off corrupt data if requested

            for { set K 0 } { $K < $nR } { incr K ; incr rVar } {
                set vR [lindex $oNames $rVar]
                global [set vR] ; upvar 0 [set vR] _fR
                set _fR(Dim) [list $nE 1]
		APxferGInfo _In _fR 

		if [string match L $B($K)] {
                   for { set L 0 } { $L < $nE } { incr L } { 
	              set _fR($L) $_Hi($L) 
	           }
                } else {
                   for { set L 0 } { $L < $nE } { incr L } {
                      set _fR($L) [expr $_TmP($L) - $_Hi($L)]
                    }
                }

                APbadGrid RESET $nE _fR NoData 0 $apANS(BaD)

               if [string match YES $_fMsK] {
                  set M  [expr $nE -1]  
                  for { set L 0 } { $L < $uH } { incr L ; incr M -1 } {
	             set _fR($L) $apANS(BaD) ; set _fR($M) $apANS(BaD)
	          }
               }
            }
         } else {

# FILTER the data to the lower cutoff

            set tC [ expr 2 * $lH + 1]
            TUsavgolCoef _C $tC $lH $lH $_dO $_sO
            FfTConvolve _TmP $bL _C $tC CONVOLVE _Lw

# FILTER the data to the upper cutoff

            set tC [ expr 2 * $uH + 1]
            TUsavgolCoef _C $tC $uH $uH $_dO $_sO
            FfTConvolve _TmP $bL _C $tC CONVOLVE _Hi

# Form the returns and mask off corrupt data if requested

            for { set K 0 } { $K < $nR } { incr K ; incr rVar } {
               set vR [lindex $oNames $rVar]
               global [set vR] ; upvar 0 [set vR] _fR
               set _fR(Dim) [list $nE 1]
	       APxferGInfo _In _fR 

	       switch -exact -- $B($K) {
	          H {
                     for { set L 0 } { $L < $nE } { incr L } { 
                       set _fR($L) [expr $_TmP($L) - $_Hi($L)]
                     } 
		     set EnD $uH
		  }
	          L {
                     for { set L 0 } { $L < $nE } { incr L } { 
		        set _fR($L) $_Lw($L) 
		     }
		     set EnD $lH
                  } 
	          B {
                     for { set L 0 } { $L < $nE } { incr L } {
                        set _fR($L) [expr $_Hi($L) - $_Lw($L)]
                     } 
                     if { $uH > $lH } { set EnD $uH } else { set EnD $lH }
                  }
	          N {
                     for { set L 0 } { $L < $nE } { incr L } {
                        set _fR($L) [expr $_TmP($L) - $_Hi($L) + $_Lw($L)]
                     } 
                     if { $uH > $lH } { set EnD $uH } else { set EnD $lH }
                  }
               }

               APbadGrid RESET $nE _fR NoData 0 $apANS(BaD)

               if [string match YES $_fMsK] {
                  set M  [expr $nE -1]  
                  for { set L 0 } { $L < $EnD } { incr L ; incr M -1 } {
	             set _fR($L) $apANS(BaD) ; set _fR($M) $apANS(BaD)
	          }
               }
            }
         }
      }
   }
}
