package provide UDFAnalysis 1.0

proc APsolveDps { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : DYNAMIC-PS"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the begin time used for any time based grid

   set bT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# GROUP sets of definitions which use a common output 

   set Starts ""
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s %s" _vI _vO
      if ![string match $apANS(EmptyVar)  $_vO] { lappend Starts $I }
   }

   set nS [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nS } { incr G } {

      if { $G != $nS } {
         set gEnD [lindex $Starts [expr $G + 1]]
      } else { set gEnD $nF }
      set gBeG [lindex $Starts $G]

# THERE are certain things that are only done once for a group.  These
#    include getting the output data set up and forming frequency
#    arrays.  Get information from the first definition in the group

      set LiNe [$W get $gBeG]
      scan $LiNe "%s %s %s %s %s %s %s %s %s %s" \
                     _vI _vO _Met _Len _Adv _nC _nF _bF _eF _Sca

# GET the output variables extablished. There should be 4 output varaiables. 
#   In order these are: 
#   1. the beg time variable, 
#   2. the ending time variable, 
#   3. the freq variable
#   4. the power spectrum variable.

      set oNames [lindex [APgetVNames $_vO] 0]
      set nP [llength $oNames]
      if { $nP < 4 } {
         puts stderr "DYNAMIC-PS: Insufficient output variables"
      }

      set vR [lindex $oNames 0] ; global [set vR ] ; upvar 0 [set vR] _tB
      set vR [lindex $oNames 1] ; global [set vR ] ; upvar 0 [set vR] _tE
      set vR [lindex $oNames 2] ; global [set vR ] ; upvar 0 [set vR] _fA
      set vR [lindex $oNames 3] ; global [set vR ] ; upvar 0 [set vR] _pS

# CHECK the data length if FFT is being used. FFT requires a power of 2
#   data points to be input.  If this is not the case then compute how
#   many pad points we need to make it so.

      if [string match FFT $_Met] {
         set bL 1
         while { $bL < $_Len } { set bL [expr $bL * 2] }
         set dPad [expr $bL - $_Len]
      } else { set dPad 0 }

# FORM the frequency array if this is an MEM filtering

      if [string match MEM $_Met] {
         set _nFb [expr double($_nF) - 1.0] 
         if [string match LOG $_Sca] {   
            set _dF [expr (log10($_eF) - log10($_bF)) / $_nFb]
            set _lbF [expr log10($_bF)]
            for { set J 0 } { $J < $_nF } { incr J } {
               set _fA($J) [expr $_lbF + $J * $_dF]
               set _fA($J) [expr pow(10.0, $_fA($J))]
            }
         } else {
            set _dF [expr ($_eF - $_bF) / $_nFb]
            for { set J 0 } { $J < $_nF } { incr J } {
               set _fA($J) [expr $_bF + $J * $_dF]
            }
         }
	 set _fA(Dim) [list $_nF 1]
	 set nFs $_nF
      }

# COUPLE of initializations
#    N is the total data counter
#    bC is the block counter

     set N 0
     set bC 0

# Process each definition

      for { set I $gBeG } { $I < $gEnD } { incr I } {

# GET the first line
   
         set LiNe [$W get $I]

# BREAK it apart

         scan $LiNe "%s %s %s %s %s %s %s %s %s %s" \
                     _vI _vO _Met _Len _Adv _nC _nF _bF _eF _Sca


# THIS is the total number of points passed into the MEM or FFT routines

         set nT [expr $_Len + $dPad]

# GET the input variable.  Should only be one so take what you get

         set iNames [lindex [APgetVNames $_vI] 0]
         set nI [llength $iNames]
         set vR [lindex $iNames 0] ; global [set vR ] ; upvar 0 [set vR] _iV

# MAKE sure that we have enough data point to compute at least one power
#   spectrum.  
      
         set nE [lindex $_iV(Dim) 0]
         if { $_Len > $nE } { return } 

# INPUT data must be in a time based grid.  Get the grid used.  If none
#   report error and exit.  

         if ![info exists _iV(gInE)] { 
            puts stderr "Variable $vR has no associated grid information"
	    exit
         }
	 APxferGInfo _iV gI DATA REVERSE 

# GET the center time per cell as well as the time spanned by a single cell.

         TUgridInfo 30 gI _tM
         set dT $gI(gIcZ)

# FORM the frequency array for FFT.

         if [string match FFT $_Met] {
            set _dF [expr 1.0 / $dT / double($_Len)]
            set _HnP [expr $_Len / 2]
	    for { set I 0 } { $I < $_HnP } { incr I } { 
	       set _fA($I) [expr $I * $_dF]
            }
	    set _fA(Dim) [list $_HnP 1]
	    set nFs $_HnP
         }

# WALK across the data set - picking up _Len points, processing, advancing
#   _Adv points and start the cycle again.
#
# BeG is the start position of the current block in the data

         set BeG 0
         set DoNext 1

# LOOP as long as there are data blocks to process

         while { $DoNext } {

# COPY data into the processing array and pad the array if necessary

            set K $BeG
            for { set J 0 } { $J < $_Len } { incr J ; incr K } {
               set _T_($J) $_iV($K)
            }

# PAD the data if necessary 

            for {  } { $J < $nT } { incr J } { set _T_($J) 0.0 }

# SOLVE for the power spectrum by the requested method

            if [string match MEM $_Met] {

# SOLVE for the MEM coefficients

	       set MsD [MaxEntCoef _T_ $_Len $_nC _CoeF]

# SOLVE for the power density at each frequency step

	       for  { set J 0 } { $J < $nFs } { incr J ; incr N } {
	          set FdT [expr $_fA($J) * $dT]
	          set _pS($N) [MaxEntPwr _CoeF $_nC $FdT $MsD]
	       }
            } else {
	       RealFfT _T_ $nT 1
	       set _pS($N) $_T_(0) ; incr N
	       set Ia 2
	       set rV [expr $nP / 2]
	       for  { set J 1 } { $J < $nFs } { incr J ; incr N } {
	          set sP [expr $_T_($Ia) * $_T_($Ia)] ; incr Ia
	          set _pS($N) [expr sqrt ($sP + $_T_($Ia) * $_T_($Ia))] 
		  incr Ia
	       }
	    }

# SET the beginning and ending time for this block

            set _tB($bC) $_tM($BeG)
            set _tE($bC) $_tM([expr $BeG + $_Adv])
            incr bC

# ADVANCE the beginning data location and make sure that there is
#   sufficient data for another block

            set BeG [expr $BeG + $_Adv]
            set EnD [expr $BeG + $_Len]
            if { $EnD > $nE } { set DoNext 0 } 
         }

# SET the array dimensions

         set _tB(Dim) [list $bC 1]
         set _tE(Dim) [list $bC 1]
         set _pS(Dim) [list $bC $nFs]
      }
   }
}
