package provide UDFAnalysis 1.0

proc APreadMOM { vD { DataAfter BEGIN } } {
   global apANS RtoD

   APkeepTabs "READING [file tail $apANS($vD,aName)]" 

#  USER specified beginning time which is in the format needed to convert the
#    times to "grid" times

   set ubT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]

# OPEN the moments file

   if [catch {open $apANS($vD,aName) r} fd ] { 
      puts stderr "CAN'T OPEN MOMENT FILE $apANS($vD,aName)"
      return -1
   } 

# INIT moment lists

   set vMOM ""
   set bMOM ""

#  READ in the file header.  This goes on until the line DataAfter.  We also
#    need to get the project from the SOURCE line.

   set StoP 0
   while { !$StoP } {
      gets $fd LiNe
      set LiNe [string trim $LiNe]
      set Fields [split $LiNe ":"]
      if { [llength $Fields] > 1 } {
         if [string match SOURCE [string trim [lindex $Fields 0]]] {
            set apANS(PMEIV) [split [lindex $Fields 1] "."]
	    set Pj [string trim [lindex $apANS(PMEIV) 0]]
	    set Ms [string trim [lindex $apANS(PMEIV) 1]]
	 }
      }
      set StoP [string match $DataAfter $LiNe]
   }

# NOW form the matrix which will translate the data from satellite to GSE
#   coordinates. Also get its transpose

   APgseMatrix $Pj $Ms rM 
   TUmatrixMath rM TRANSPOSE rM rT 3 3 3 3

# CHECK to see if we need to also rotate the data into a magnetic field
#    based coordinate system.  This requires MF data which is in GSE.

# CHECK to see if there is MF field info and if so are we returning any
#  MF based data (begins with b)

   set BRot 0
   if { [string length $apANS($vD,MagF)] > 0 } {
      set mN [lindex [APgetVNames $apANS($vD,aVar)] 0]
      set nV [llength $mN]
      for { set I 0 } { $I < $nV } { incr I } {
         set MoM  [lindex $mN $I]
	 if [string match b [string index [lindex $mN $I] 0]] {
	    set BRot 1
	    break
         }
      }

      if $BRot {
         set mN [lindex [APgetVNames $apANS($vD,MagF)] 0]
         set Var [lindex $mN 0] ; global [set Var] ; upvar 0 [set Var] _Bx
         set Var [lindex $mN 1] ; global [set Var] ; upvar 0 [set Var] _By
         set Var [lindex $mN 2] ; global [set Var] ; upvar 0 [set Var] _Bz
	 APxferGInfo _Bx gIM DATA REVERSE
      }
   }

# THIS is the data format

   set FmT "%d %d %s %d %d %s %e %e %e %e %e %e %e %e %e %e %e %e \
            %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e" 

# READ through the data and get the data within the requested time
#    period.  We are only getting the density and linear velocities.
#    Also compute the total velocity

   set nV 0
   set EOF [gets $fd LiNe]
   while { $EOF >= 0 } {
      if { $EOF == 0 } { continue }

      scan $LiNe $FmT bY bD bT eY eD eT D _V1(0) _V1(1) _V1(2) \
                      _V2(0) _V2(1) _V2(2) _V2(3) _V2(4) _V2(5) \
                      _V3(0) _V3(1) _V3(2) _V3(3) _V3(4) \
                      _V3(5) _V3(6) _V3(7) _V3(8) _V3(9) \
                      _F(0) _F(1) _F(2) _F(3) _F(4) _F(5) \
		      _F(6) _F(7) _F(8) _F(9)

      set T [split $bT ":"]
      set hr [string trimleft [lindex $T 0] "0"]
      if { [string length $hr] == 0 } { set hr 0 }
      set mn [string trimleft [lindex $T 1] "0"]
      if { [string length $mn] == 0 } { set mn 0 }
      set sc [string trimleft [lindex $T 2] "0"]
      set bM [expr int($hr * 3600000 + $mn * 60000 + $sc * 1000)]
      set Tb [list $bY $bD $bM 0]

      set T [split $eT ":"]
      set hr [string trimleft [lindex $T 0] "0"]
      if { [string length $hr] == 0 } { set hr 0 }
      set mn [string trimleft [lindex $T 1] "0"]
      if { [string length $mn] == 0 } { set mn 0 }
      set sc [string trimleft [lindex $T 2] "0"]
      set eM [expr int($hr * 3600000 + $mn * 60000 + $sc * 1000)]
      set Te [list $eY $eD $eM 0]

      APconvMOM rM rT _V1 _V2 _V3

# SAVE the grid based times

      set tMb($nV) [TUtimeConv $ubT $Tb 0 apANS(tBase)]
      set tMe($nV) [TUtimeConv $ubT $Te 0 apANS(tBase)]

# SAVE the raw moment data

      lappend vMOM [list $bY $bD $bM $eY $eD $eM $D \
         $_V1(0) $_V1(1) $_V1(2) $_V2(0) $_V2(1) $_V2(2) $_V2(3) \
	 $_V2(4) $_V2(5) $_V3(0) $_V3(1) $_V3(2) $_V3(3) $_V3(4) \
	 $_V3(5) $_V3(6) $_V3(7) $_V3(8) $_V3(9) $_F(0) $_F(1) \
	 $_F(2) $_F(3) $_F(4) $_F(5) $_F(6) $_F(7) $_F(8) $_F(9) ]

# IF we need compute MF based moments do the rotations here.

      if $BRot {
         set P [expr ($tMb($nV) + $tMe($nV)) / 2.0]
	 TUgridInfo 0 gIM rV $P 0.0 
	 set gP $rV(0)
	 if { $gP >= 0 } {
	    set Bxy [expr sqrt($_Bx($gP) * $_Bx($gP) +  $_By($gP) * $_By($gP))]
	    set Bp [expr atan2($_By($gP), $_Bx($gP)) * $RtoD]
	    set Bt [expr atan2($_Bz($gP), $Bxy) * $RtoD]

	    TUmatrixRot $Bp 0. 0. rZ Z
	    TUmatrixRot $Bt 0. 0. rY Y
	    TUmatrixMath rY * rZ rB 3 3 3 3

            TUmatrixMath rB TRANSPOSE rB rBT 3 3 3 3
#    set BB(0) $_Bx($gP)
#    set BB(1) $_By($gP)
#    set BB(2) $_Bz($gP)
#    TUmatrixMath rB * BB BBB  3 3 3 1

	    APconvMOM rB rBT _V1 _V2 _V3
         }

         lappend bMOM [list $bY $bD $bM $eY $eD $eM $D \
            $_V1(0) $_V1(1) $_V1(2) $_V2(0) $_V2(1) $_V2(2) $_V2(3) \
	    $_V2(4) $_V2(5) $_V3(0) $_V3(1) $_V3(2) $_V3(3) $_V3(4) \
	    $_V3(5) $_V3(6) $_V3(7) $_V3(8) $_V3(9) $_F(0) $_F(1) \
	    $_F(2) $_F(3) $_F(4) $_F(5) $_F(6) $_F(7) $_F(8) $_F(9) ]
      }

      incr nV

# GET the velocity into the right coordinate system.


      set EOF [gets $fd LiNe]
   }
   close $fd

#  GET the variable names and the elements we are to get

   set vI [APgetVNames $apANS($vD,aVar)]
   set mN [lindex $vI 0]
   set vI [APgetVNames $apANS($vD,Var)]
   set vN [lindex $vI 0]

   set nE [llength $mN] 

#  GET and store the data.  Data will be stored in a grid or in an array. 

   for { set I 0 } { $I < $nE } { incr I } {
      set MoM  [lindex $mN $I]
      set Var  [lindex $vN $I]
      global [set Var]
      upvar 0 [set Var] GriD

      APkeepTabs "CREATING $Var"
      if [string match b [string index $MoM 0]] {
         set MoM [string range $MoM 1 end]
         APgetMOM $bMOM $MoM rV 9.11e-31
      } else { APgetMOM $vMOM $MoM rV 9.11e-31 }

      if [string match YES $apANS($vD,gData)] {
         APgridData $vD $nV tMb tMe Y Y rV GriD NorM
         set GriD(Dim) [list $GriD(gI4) 1]
      } else {
         for { set J 0 } { $J < $nV } { incr J } { set GriD($J) $MoM($J) }
         set GriD(Dim) [list $nV 1]
      }
   }

# SAVE the time variables if we need to.

   set vA [lindex [APgetVNames $apANS($vD,tmV)] 0]
   set nT [llength $vA]
   if  { $nT > 0 } {
      set Var  [lindex $vA 0] ; global [set Var]
      upvar 0 [set Var] tV
      for { set J 0 } { $J < $nV } { incr I } { set tV($J) $tMb($J) }
      set tV(Dim) [list $nV 1]
      if { $nT > 1 } {
         set Var  [lindex $vA 1] ; global [set Var]
         upvar 0 [set Var] tV
         for { set J 0 } { $J < $nV } { incr I } { set tV($J) $tMe($J) }
         set tV(Dim) [list $nV 1]
      }
   }
}
