package provide UDFAnalysis 1.0

proc APplots3DTime { pD Var } {
   global apANS GphInfo PltInfo WinInfo

   upvar $Var vN

# SET the plot number and the index into the plot definitions where the plot
#   information is contained.

   set P $apANS($pD,pID)
   set pS [lindex $apANS($P) 0]
   set pN $apANS($pS,Col).$apANS($pS,Row)

# SET the plot axes  

   set aX $apANS($pD,xActive) 
   set aY $apANS($pD,yActive)
   if [string match Yl $aY] { set ySca ylSca } else { set ySca yrSca }

# GET the plot type.  Should be SOLID or CONTOUR.

   set pType $apANS($pD,pType)

# GET the intensity variable information and the array size, each 
#   dimension and total

   set vI [lindex $vN(3) 0] ; global [set vI] ; upvar 0 [set vI] _iV
   set nI0 [lindex $_iV(Dim) 0]
   set nI1 [lindex $_iV(Dim) 1]
   set tI  [expr $nI0 * $nI1]

# GET the Y variable information and the array size, each dimension 
#    and total

   set nyV [llength $vN(1)]

   set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Y0
   if { $nyV == 1 } { set I 0 } else { set I 1 }
   set vY [lindex $vN(1) $I] ; global [set vY] ; upvar 0 [set vY] _Y1
   set nY0 [lindex $_Y0(Dim) 0]
   set nY1 [lindex $_Y0(Dim) 1]
   set tY [expr $nY0 * $nY1] 

# GET the X varaible information If there is no X variable then the data 
#   has already been gridded to the system wide time grid.  In this case 
#   we need to form the X variables here otherwise set them to what's been 
#   passed in.

   set nxV [llength $vN(0)]
   if { $nxV == 0 } {

# THIS should be the system wide time grid information

      APxferGInfo _iV gI DATA REVERSE
  
# BUILD the tMb and tMe time arrays 

      TUgridInfo 30 gI _tT

      for { set I 0 ; set J 1 } { $J <= $nI0 } { incr I ; incr J } {
         set _T0($I) $_tT($I)
         set _T1($I) $_tT($J)
      }
      set nX0 $nI0
      set nX1 1
   } else {
      set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _T0
      set nX0 [lindex $_T0(Dim) 0]
      set nX1 [lindex $_T0(Dim) 1]
      if { $nxV == 1 } { set I 0 } else { set I 1 }
      set vX [lindex $vN(0) $I] ; global [set vX] ; upvar 0 [set vX] _T1
   }

# Total length of X (or time) array

   set tX [expr $nX0 * $nX1] 

# SINCE the data set is not gridded we need to grid it according to both
#   the plot and the input variables.

# MAKE the following alterations to the grid definition
#   1. If there is only 1 X variable then change X Storage to POINT
#   2. If there is only 1 Y variable then change Y Storage to POINT
#   3. apANS($pS,dX) is the number of pixels across the plot which 
#      is the number of X cells in the grid
#   4. The number of cells along Y is the Y array dimension
#   5. The min and max values along the Y axis are the min and max of
#      the input Y arrays

   if { $nxV == 1 } { set xS POINT } else { set xS BAND }
   if { $nyV == 1 } { set yS POINT } else { set yS BAND }

   if { $tY == 1 } {
      set MnY $_Y0(0)
      set MxY $_Y0(0)
   } else {
      set MnMx [TUdataMxMn _Y0 $tY <> 0.0]
      set MnY $_Y0([lindex $MnMx 0])
      set MxY $_Y0([lindex $MnMx 1])
   }

   if { $nyV == 2 } {
      if { $tY == 1 } {
         set MnYa $_Y1(0)
         set MxYa $_Y1(0)
      } else {
         set MnMx [TUdataMxMn _Y1 $tY <> 0.0]
         set MnYa $_Y1([lindex $MnMx 0])
         set MxYa $_Y1([lindex $MnMx 1])
      }

      if { $MnY >  $MnYa } { set MnY $MnYa }
      if { $MxY <  $MxYa } { set MxY $MxYa }
   }

# IF the Y axis is log scaled then we need to take the log of the Y min and
#   max in the grid information

   if [string match LOG $apANS($pS,$ySca)] {
      set MnY [expr log10($MnY)]
      set MxY [expr log10($MxY)]
   }
     
# HERE is a list of the grid info parameters to modify from the base
#   settings

   if { $nY1 == 1 } { set nY $nY0 } else { set nY $nY1 }
   if ![string match FLAT $apANS(tDFmt)] {
      set nXG [expr int($apANS($pS,dX) / $apANS(tDDec))]
      set gC [list 2 $MnY 3 $MxY 4 $nXG 5 $nY 6 $xS 7 $yS]
   } else { 
      set dY [expr int(abs( $apANS($pN,ypT) - $apANS($pN,ypB))) + 1]
      if { $dY > $nY } { set dY $nY }
      set gC [list 2 $MnY 3 $MxY 4 $apANS($pS,dX) 5 $dY 6 $xS 7 $yS] 
   }

# MAKE the grid and get the get a local copy of the grid information

   APmakeGrid _gIP BAND $gC

# FINE tune the number of cells along X
 
#  set nV [lindex $_T0(Dim) 0]
#  set dT 0
#  for { set I 0 ; set J 1 } { $J < $nV } { incr I ; incr J } {
#      set dT [expr $dT + $_T0($J) - $_T0($I)]
#  }
#  set dT [expr $dT / ($nV - 1)]
#  set dX [expr int(($_gIP(1) - $_gIP(0)) / $dT) + 1]
#  set _gIP(4) $dX

#  If the Y axis is LOG scaled we need take the log of the Y values before
#    gridding.

   if [string match LOG $apANS($pS,$ySca)] {
      TUarrayMath _Y0 LOG10 _Y0 _Y0 $tY
      if { $nyV == 2 } { TUarrayMath _Y1 LOG10 _Y1 _Y1 $tY }
   } 

# NEED to compute the skip values for each array

   set sX [expr int($tI / $tX)]
   set sY [expr int($tI / $tY)]

#  if { $sY != 1 } { set sY [expr -$nY0] }
   if { $sY != 1 } { set sY [expr -$nY] }

   TUdataGrid $tI $sX _T0 _T1 $sY _Y0 _Y1 _iV _Grid _NorM _gIP

#  If the Y axis was LOG scaled we need reconvert the Y arrays

   if [string match LOG $apANS($pS,$ySca)] {
      TUarrayMath _Y0 ALOG10 _Y0 _Y0 $tY
      if { $nyV == 2 } { TUarrayMath _Y1 ALOG10 _Y1 _Y1 $tY }
   } 

# Fill for gaps in Y

   TUgridFill1D _Grid _gIP Y LI -1 1 _Norm 

# SET up the color map

   set cMin [lindex $apANS($pN.cB) 0]
   set cMax [lindex $apANS($pN.cB) 1]
   PLTcolorMap $cMin $cMax $apANS($pS,cbSca) NO cMap

# GET the cell edges along the X and Y grid directions for FLAT plots or
#   centers for elevated plots.  For FLAT plots need to reconvert LOG
#   values if they were converted in the first place.

   if [string match FLAT $apANS(tDFmt)] {
      TUgridInfo 30 _gIP _X
      TUgridInfo 31 _gIP _Y
      set yLen [expr $_gIP(5) + 1]
      if [string match LOG $apANS($pS,$ySca)] {
         TUarrayMath _Y ALOG10 _Y _Y [expr $_gIP(5) + 1]
      }
   } else {
      TUgridInfo 32 _gIP _X
      TUgridInfo 33 _gIP _Y
   }

# PUT up the plot

   set _gIP(PF) $apANS(tDFmt)
   if [string match FLAT $apANS(tDFmt)] {
      PLTflatPlot $pN $aX $aY _X _Y _Grid MANUAL _gIP cMap 
   } else { PLTvtk3DGrid $pN _X _Y _Grid _gIP cMap } 

   unset _gIP
   unset _X
   unset _Y
   unset _Grid

   update
}
