# THIS procedure scales all axes of the plots which are being autoscaled.
#   This includes the intensity axis, although in that case all it does
#   is save the min and max of the axis.
 
package provide UDFAnalysis 1.0

proc APplotScale { } {
   global apANS GphInfo WinInfo PltInfo

# GENERIC auto scale options
 
   set aOp [list $apANS(BaDL) $apANS(BaDU) OFF  OFF  OFF  OFF  OFF  OFF 0]

# THIS is the number of plot grids defined. 

   if ![winfo exists .apLAYOUT] { APlayoutGui 1 }
   set Wps .apLAYOUT.body.list
   set nP [$Wps index end]

# Loop over the plots

   for { set I 0 } { $I < $nP } { incr I } {
      scan [$Wps get $I] "%d" sN

# THIS is the plot iD.

      set P $apANS($sN,piD)

# IF this is an unused plot then skip it

      if [string match _DP_ $P] { continue }

# ESTABLISH the plot parameters

      APplotParms $sN

# THIS is the plot: slot number, plot number and window number

      set pS [lindex $apANS($P) 0]
      set _pN $apANS($pS,Col).$apANS($pS,Row)
      set wN $PltInfo($_pN,wN)

# SET up the autoscaling axis array.  We don't autoscale time based X
#    axis no matter what the options say.
 
      set aS "" 
      if { [llength $apANS($P.Yl)] > 0 } { 
           lappend aS [list Yl Yl Yr 4 $apANS($pS,ylSca)] 
      }
      if { [llength $apANS($P.Yr)] > 0 } { 
         lappend aS [list Yr Yr Yl 3 $apANS($pS,yrSca)] 
      }
      if { ($WinInfo($wN,Dimen) == 3) } {
         if { [llength $apANS($P.Z)] > 0 } { 
	     lappend aS [list Z Zb Zt -1 $apANS($pS,zaSca)] 
	 }
      }
      if ![string match YES $apANS($pS,tBased)] { 
         if { [llength $apANS($P.Xb)] > 0 } { 
	    lappend aS [list Xb Xb Xt 2 $apANS($pS,xbSca)] 
	 }
         if { [llength $apANS($P.Xt)] > 0 } { 
	    lappend aS [list Xt Xt Xb 1 $apANS($pS,xtSca)] 
	 }
      }

# AUTOSCALE the axes which need to be autoscaled
 
      set nAS [llength $aS]
      for { set J 0 } { $J < $nAS } { incr J } {
         set aI [lindex $aS $J]
         set iD [lindex $aI 0]
         set nV [llength $apANS($P.$iD)]
         for { set K 0 ; set L 0 } { $K < $nV } { incr K } {
            set vR [lindex $apANS($P.$iD) $K]
	    set Var [lindex [lindex [APgetVNames $vR] 0] 0]
            global [set Var] ; upvar 0 [set Var] V

	    if [info exist V(aType)] { continue }

# GET the locations of the first and last cell in the time grid which 
#  corresponds to the time covered by the plot 

            if [string match YES $apANS($pS,tBased)] {
	       APtimeSpan V BeG EnD

# This is the number of data points covered 

               set nE [expr $EnD - $BeG]
               set nE [expr $nE * [lindex $V(Dim) 1] ] 
             } else {
	          set BeG 0
                  set nE [expr [lindex $V(Dim) 0] * [lindex $V(Dim) 1] ] 
	     }


# NEED to ingore anything <= 0 if the axis is log scaled.

            if [string match LINEAR [lindex $aI 4]] {
               set rV [TUdataMxMn V $nE <> $apANS(BaDL) $apANS(BaDU) 1 $BeG] 
            } else { set rV [TUdataMxMn V $nE <> 0.0 $apANS(BaDU) 1 $BeG] }

	    if { ([lindex $rV 0] < 0) || ([lindex $rV 1] < 0) } {
	       puts stderr "AUTOSCALE ERROR on $Var"
	       exit
	    }

            set sA($L) $V([lindex $rV 0]) ; incr L
            set sA($L) $V([lindex $rV 1]) ; incr L
         }

         AutoScale $_pN [lindex $aI 1] sA $L $aOp
         if { [lindex $aI 3] >= 0 } {
            if ![lindex $apANS($P) [lindex $aI 3]] { 
               AutoScale $_pN [lindex $aI 2] sA $L $aOp
            }
         }
      }

# AUTOSCALE the intensity axis if it needs to be autoscaled.  All we do 
#   here is set the axis max and min values for later use.
 
      set nV [llength $apANS($P.I)]
      if { $nV > 0 } { 
         set cMin $apANS(BaDU) ; set cMax $apANS(BaDL)
         for { set K 0 } { $K < $nV } { incr K } {
            set Var [lindex $apANS($P.I) $K]
            global [set Var] ; upvar 0 [set Var] V
	    if [info exist V(aType)] { continue }
            set nE [expr [lindex $V(Dim) 0] * [lindex $V(Dim) 1] ] 
	    if [string match LINEAR $apANS($pS,cbSca)] {
	       set cLow $apANS(BaDL)
            } else { set cLow 0.0 }

            set rV [TUdataMxMn V $nE <> $cLow $apANS(BaDU)] 
	    if { $V([lindex $rV 0]) < $cMin } { set cMin $V([lindex $rV 0]) }
	    if { $V([lindex $rV 1]) > $cMax } { set cMax $V([lindex $rV 1]) }
         }

         set apANS($_pN.cB) \
	      [PLTautoScale $cMin $cMax $apANS($pS,cbSca) $apANS($pS,cbMjT)]
      } else {set apANS($_pN.cB) [list $apANS($pS,cbMin) $apANS($pS,cbMax) 0]} 
   }
}
