package provide UDFAnalysis 1.0

# ESTABLISH a grid information array based on the provided inputs.  
#   By default the grid is set up as a 1D grid with POINT storage,
#   spanning the DATA input time interval.  You can quick change some
#   of the default parameters using gB and Base. 
#
#   All fields are changeable through gC
  
proc APmakeGrid { gN { gB POINT } { gC "" } { gT SYSTEM } { Base DATA } } {
   global apANS

   upvar $gN gI

# SET up the default time interval according to Base

   set bTD [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
   if [string match DATA $Base] {
     set bT $bTD
     set eT [list $apANS(endYr) $apANS(endDy) $apANS(endMs) 0]
   } else {
      set bT [list $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs) 0]
      set eT [list $apANS(PendYr) $apANS(PendDy) $apANS(PendMs) 0]
   }

# SET up the default grid

   set gI(0) [TUtimeConv $bTD $bT 0 apANS(tBase)]
   set gI(1) [TUtimeConv $bTD $eT 0 apANS(tBase)]
   set gI(2) -1.0
   set gI(3) 1.0
   set gI(4) 1
   set gI(5) 1
   set gI(6) $gC
   set gI(7) $gC
   set gI(8) COLUMN
   set gI(9) KEEP
   set gI(10) NEW:ADD:END
   set gI(11) $apANS(BaD)
   set gI(12) $apANS(BaD)
   set gI(13) $apANS(BaDL)
   set gI(14) $apANS(BaDU)
   set gI(15) NO
   set gI(16) NO
   set gI(17) LINEAR
   set gI(18) LINEAR

   set gI(gInE) $apANS(numGI)
   set gI(gItB) YES

   if [string match SYSTEM $gT]  { set cZ $apANS(CellSz) } else { set cZ $gT }

# If the time base is 0 need to convert cZ to days.  Will be in seconds.
 
   if { $apANS(tBase) == 0 } { set cZ [expr $cZ / 86400.0] }

   set dT [expr $gI(1) - $gI(0)]
   if { [expr fmod($dT, $cZ)] != 0.0 } { 
      set gI(4) [expr int($dT / $cZ) + 1]
   } else { set gI(4) [expr int($dT/ $cZ)] }

# OK - now that the default grid information array is constructed go ahead and
#   change whatever entries need to be altered

   set nC [llength $gC]
   for { set I 0 ; set J 1 } { $I < $nC } { incr I 2 ; incr J 2 } {
      set gI([lindex $gC $I]) [lindex $gC $J]
   }

# COMPUTE the cell width

   set dT [expr $gI(1) - $gI(0)]
   set gI(gIcZ) [expr $dT / $gI(4)]
}
