# THIS procedure builds a tranformation matrix to take a set of units 
#    computed in spacecraft coordinates to another coordinate system.
#    NOTE: this a mission dependent and may not exist for all missions!

package provide UDFAnalysis 1.0

proc APgseMatrix { P M mT } {
   global apANS RtoD 

   upvar $mT rM
   
# DEFAULT the matrix to the unit matrix

   TUmatrixMath rM UNIT rM rM 3 3 3 3

# Convert the user begin time to HMS.

   set tM [TUtimeFmt 1 $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
   set bH [lindex $tM 2]
   set bM [lindex $tM 3]
   set bS [lindex $tM 4]
   set tM [TUtimeFmt 1 $apANS(endYr) $apANS(endDy) $apANS(endMs) 0]
   set eH [lindex $tM 2]
   set eM [lindex $tM 3]
   set eS [lindex $tM 4]

# SPECIAL NOTES:
#   CLUSTER II: CLUSTERII has spacecraft X parallel to the spin axis while
#      the moments are computed with Z parallel to the spin axis so we need
#      to do a transformation to move Z -> X,  X -> Y and Y -> Z.  We can
#      call that cS 

   switch -exact -- $P {
      CLUSTERII { 
         switch -exact -- $M {
            CLUSTER-1 { set S1 24 ; set S2 25 }
	    CLUSTER-2 { set S1 26 ; set S2 27 }
	    CLUSTER-3 { set S1 28 ; set S2 29 }
	    CLUSTER-4 { set S1 30 ; set S2 31 }
	 }

         set cS(0) 0.0 ; set cS(1) 0.0 ; set cS(2) 1.0
         set cS(3) 1.0 ; set cS(4) 0.0 ; set cS(5) 0.0
         set cS(6) 0.0 ; set cS(7) 1.0 ; set cS(8) 0.0

         set Key [GetDataKey CLUSTERII CLUSTER_SP AUXILIARY SUMMARY CAUSUM]
         FileOpen $Key 0 $apANS(begYr) $apANS(begDy) $bH $bM $bS \
	                 $apANS(endYr) $apANS(endDy) $eH $eM $eS
         FilePos  $Key 0 $apANS(begYr) $apANS(begDy) $bH $bM $bS

         set Ua [UTILunits $Key,0 6 $S1]
         set Ub [UTILunits $Key,0 7 $S2]

         ReadUDF $Key 0 0 $S1 0 0 0
         set Lat  [ConvertToUnits $Key 0 0 $Ua rV]
         ReadUDF $Key 0 0 $S2 0 1 0
         set Long [ConvertToUnits $Key 0 0 $Ub rV]

         set Lat [expr $Lat / $RtoD]
         set Long [expr $Long / $RtoD]
         set cT [expr cos($Lat)]  ; set sT [expr sin($Lat)]
         set cP [expr cos($Long)] ; set sP [expr sin($Long)]
         set B [expr 1.0/sqrt($sT * $sT + $cT * $cT * $sP * $sP)]

         set RoT(0) [expr $cT * $cP]
         set RoT(1) [expr $B * ($sT * $sT + $cT * $cT * $sP * $sP)]
         set RoT(2) 0.0
         set RoT(3) [expr $cT * $sP]
         set RoT(4) [expr -$B * $cT * $cT * $cP * $sP]
         set RoT(5) [expr $B * $sT]
         set RoT(6) $sT
         set RoT(7) [expr -$B * $cT * $sT * $cP]
         set RoT(8) [expr -$B * $cT * $sP]

         TUmatrixMath RoT * cS rM 3 3 3 3
      }
   }
}
