package provide UDFAnalysis 1.0

# THIS procedure returns the variable names which should be assigned to the
#   data. It also returns the element names and it checks if the variable
#   is a constant value which can be used by some function definitions
#
#   For varaible array list the base name specification is X.Y:Z where X 
#   is the number of variable names to get, Y is the starting location in 
#   the variable name list and Z is a skip element.  Hence the sepcification
#   6.4:2,V will return the names V4 and V6.

proc APgetVNames { vList } {
   global apANS

   set vNames ""
   set vType ""

   if [string match $apANS(EmptyVar) $vList] {
      set nE 0
   } else { set nE [llength $vList] }

   for { set I 0 } { $I < $nE } { incr I } {
      set V [lindex $vList $I]
      set dP [string first "$" $V]
      if { $dP >= 0 } {
         lappend vType 1
         set pPb [string first "(" $V]
         if { $pPb > 0 } {
            set pPe [string first ")" $V]
	    set bV [expr $dP + 1] ; set eV [expr $pPb - 1]
	    set bN [expr $pPb + 1] ; set eN [expr $pPe - 1]
	    set vN [string range $V $bV $eV]
	    set eL [string range $V $bN $eN]
	    global [set vN ] ; upvar 0 [set vN] _TmP 
            lappend vNames $_TmP($eL) 
         } else { 
	    set vN [string range $V 1 end]
	    global [set vN ] ; upvar 0 [set vN] _TmP 
            lappend vNames $_TmP 
         }
      } elseif [regexp {^[+-]?(([0-9]*\.[0-9]+)|([0-9]+\.[0-9]*)|([0-9]+))((e|E)[+-]?[0-9]+)?$} $V] {
         lappend vType 1
         lappend vNames $V 
      } else {
         set vE [split $V ","]
         set nV [llength $vE] 
         if { $nV > 1 }  {
            set vP [lindex $vE 0]
            set vN [lindex $vE 1]
            switch -exact -- $vP {
               vec -
               Vec {
                  lappend vType 0; lappend vNames ${vN}x 
                  lappend vType 0; lappend vNames ${vN}y
                  lappend vType 0; lappend vNames ${vN}z
               }

	       default {
	          set tA [string first "." $vP]
		  set Len [string range $vP 0 [expr $tA - 1]]
	          set tB [string first ":" $vP]
		  if { $tB >= 0 } {
		     set BeG [string range $vP [expr $tA + 1] [expr $tB - 1]]
		     set Skip [string range $vP [expr $tB + 1] end]
#	             incr Skip
		  } else { 
		     set BeG [string range $vP [expr $tA + 1] end]
		     set Skip 1 
		  }

		  if { [string length $BeG] == 0 } { set BeG 0 }
	          for { set J 0 } { $J < $Len } { incr J ; incr BeG $Skip } {
		     set vID ${vN}$BeG
		     if [info exists apANS($vID,rm)] { set vID $apANS($vID,rm) }
	             lappend vType 0; lappend vNames $vID
                  }
	       }
	    }
         } else { 
	    if [info exists apANS($vE,rm)] { set vE $apANS($vE,rm) }
            lappend vNames $vE 
            lappend vType 0 
         }
      }
   }

   return [list $vNames $vType]
}
