package provide UDFAnalysis 1.0

proc APfitGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set YN [list YES NO]

   set mN FIT
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaB [format $FmT LSq Dim Inputs Sca Coef PreSets Function Output]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 57 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      incr R 
      GUIblankCol $We 0 1
      GUILabel $We.l0  "Least-Squares" c grid|$R|1|e -1 0 "" $LFonT
      GUIblankCol $We 2 1
      GUIbuttonToggle $We.fit $apANS($fD,fType) grid|$R|3|w $YN  \
	                  "GUIoptsToggle $We.fit apANS($fD,fType) PRI" 0,0.5
      GUIblankCol $We 4 6
      GUIboxEntry $We.fd grid|$R|5|news 20 apANS($fD,fDim)
      GUIblankCol $We 6 1
      GUILabel $We.l1  "Dimension" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l2  "Inputs" c grid|$R|1|e -1 0 "" $LFonT
      GUIboxEntry $We.fi grid|$R|3|news 20 apANS($fD,fXYZI)
      GUIboxEntry $We.fs grid|$R|5|news 20 apANS($fD,fSca)
      GUILabel $We.l3  "Scaling" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l4  "Coefficients" c grid|$R|1|e -1 0 "" $LFonT
      GUIboxEntry $We.fc grid|$R|3|news 20 apANS($fD,fCoef)
      GUIboxEntry $We.fw grid|$R|5|news 20 apANS($fD,cPset)
      GUILabel $We.l5  "PreSets" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l6  "Function" c grid|$R|1|e -1 0 "" $LFonT
      GUIboxEntry $We.ff grid|$R|3|news 20 apANS($fD,fFunc)
      GUIboxEntry $We.fo grid|$R|5|news 20 apANS($fD,fO)
      GUILabel $We.l7  "Output" c grid|$R|7|w -1 0 "" $LFonT

      bind $W <Down> { APtwinCmd FIT %W MOVE DOWN }
      bind $W <Up> { APtwinCmd FIT %W MOVE UP }

      APallInits  $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI   $mN $fD

   } else { GUIwindowCtrl $W }
}
