# INPUTS
#    iGrid   - the input grid
#    igInfo  - the input grid information array
#    oGrid   - the output (expanded) grid
#    ogInfo  - the output grid information array
#    xF      - number of cells to add between input grid cells along X
#    yF      - number of cells to add between input grid cells along Y

package provide TDShock 1.0

proc Smooth2D { GriD gRID XpT YpT ZpT } {

   upvar $GriD  G
   upvar $gRID gI
   upvar $XpT   X
   upvar $YpT   Y
   upvar $ZpT   Z

   set IncX [expr ($gI(1) - $gI(0)) / $gI(4)]
   set IncY [expr ($gI(3) - $gI(2)) / $gI(5)]

# FORM two vectors which define the triangle.  Both radiate from the first
#   point to the remaining two points

   set V(0) [expr $X(1) - $X(0)] 
   set V(1) [expr $Y(1) - $Y(0)] 
   set V(2) [expr $Z(1) - $Z(0)] 
   set V(3) [expr $X(2) - $X(0)] 
   set V(4) [expr $Y(2) - $Y(0)] 
   set V(5) [expr $Z(2) - $Z(0)] 

# THE cross product of the two vectors forms the normal to the plane and
#   allows easy solution to the equation of the plane
#
#          Ax + By + Cz - D = 0 
#

   TUvecMath V CROSS V Vc 0 3 0
   set Vc(3) [expr $Vc(0) * $X(0) + $Vc(1) * $Y(0) + $Vc(2) * $Z(0)]

# ORDER the data along X 

   if { $X(0) < $X(1) } { 
      if { $X(0) < $X(2) } { set I 0 } else { set I 2 }  
   } elseif { $X(1) < $X(2) } { set I 1 } else { set I 2 }  

   if { $I == 0 } {
      if { $X(1) < $X(2) } { set J 1 ; set K 2 } else { set J 2 ; set K 1 }  
   } elseif { $I == 1 } {
      if { $X(0) < $X(2) } { set J 0 ; set K 2 } else { set J 2 ; set K 0 }  
   } else { 
      if { $X(0) < $X(1) } { set J 0 ; set K 1 } else { set J 1 ; set K 0 }  
   }

# Equations connecting the three points

   set dX [expr $X($J) - $X($I)]
   set A1 [expr ($Y($J) - $Y($I)) / $dX]
   set B1 [expr $Y($I) - $A1 * $X($I)]
   set dX [expr $X($K) - $X($I)]
   set A2 [expr ($Y($K) - $Y($I)) / $dX]
   set B2 [expr $Y($I) - $A2 * $X($I)]
   set dX [expr $X($K) - $X($J)]
   set A3 [expr ($Y($K) - $Y($J)) / $dX]
   set B3 [expr $Y($J) - $A3 * $X($J)]

   TUgridInfo 0 gI rV $X($I) $Y($I)
   set C($I) $rV(1)
   set R($I) $rV(2)
   TUgridInfo 20 gI rV $rV(0)
   set xC($I) $rV(2)
   set yC($I) $rV(3)
   TUgridInfo 0 gI rV $X($J) $Y($J)
   set C($J) $rV(1)
   set R($J) $rV(2)
   TUgridInfo 20 gI rV $rV(0)
   set xC($J) $rV(2)
   set yC($J) $rV(3)
   TUgridInfo 0 gI rV $X($K) $Y($K)
   set C($K) $rV(1)
   set R($K) $rV(2)
   TUgridInfo 20 gI rV $rV(0)
   set xC($K) $rV(2)
   set yC($K) $rV(3)

   set Col -1
   set X1 $xC($I)
   while { $Col <= $C($J) } { 
     set Y1 [expr $A1 * $X1 + $B1]
     TUgridInfo 0 gI rV1 $X1 $Y1
     set Y2 [expr $A2 * $X1 + $B2]
     TUgridInfo 0 gI rV2 $X1 $Y2
     if { $rV1(2) < $rV2(2) } {
       set rBeG $rV1(2) 
       set rEnD $rV2(2) 
       set yBeG $Y1
       set gBeG $rV1(0)
     } else { 
       set rBeG $rV2(2) 
       set rEnD $rV1(2) 
       set yBeG $Y2 
       set gBeG $rV2(0) 
     } 
     while { $rBeG <= $rEnD } {
        set G($gBeG) [expr ($Vc(3) - $Vc(0) * $X1 - $Vc(1) * $yBeG)/$Vc(2)] 
        set yBeG [expr $yBeG + $IncY]
        incr rBeG 
        incr gBeG 
     }
     set Col $rV1(1)
     set X1 [expr $X1 + $IncX]
  }

   set Col -1
   set X1 $xC($J)
   while { $Col <= $C($K) } { 
     set X1 [expr $X1 + $IncX]
     set Y1 [expr $A2 * $X1 + $B2]
     TUgridInfo 0 gI rV1 $X1 $Y1
     set Y2 [expr $A3 * $X1 + $B3]
     TUgridInfo 0 gI rV2 $X1 $Y2
     if { $rV1(2) < $rV2(2) } {
       set rBeG $rV1(2) 
       set rEnD $rV2(2) 
       set yBeG $Y1
       set gBeG $rV1(0)
     } else { 
       set rBeG $rV2(2) 
       set rEnD $rV1(2) 
       set yBeG $Y2 
       set gBeG $rV2(0) 
     } 
     while { $rBeG <= $rEnD } {
        set G($gBeG) [expr ($Vc(3) - $Vc(0) * $X1 - $Vc(1) * $yBeG)/$Vc(2)] 
        set yBeG [expr $yBeG + $IncY]
        incr rBeG 
        incr gBeG 
     }
     set Col $rV1(1)
  }
}
