package provide TDShock 1.0

# THIS procedure takes the tetrahedron data and organizes so that the
#   side being interpolated is in the first three positions in the
#   vertex arrays and the out of plane point is in the last location.
#
#  INPUTS:   iP:   array of vertices as sets of (X,Y,Z,V)
#            ooP:  the out of plane point
#
#  OUTPUTS:  vX:   array of X coordinates of the 4 vertices
#            vY:   array of Y coordinates of the 4 vertices
#            vZ:   array of Z coordinates of the 4 vertices
#            vV:   array of values for the 4 vertices


proc OrderData { iP vX vY vZ vV ooP } {
   global RtoD
  
   upvar $iP D
   upvar $vX X
   upvar $vY Y
   upvar $vZ Z
   upvar $vV V

# LOOP over vertices.  The out of plane vertex is always stored in the
#   last slot of the vertex arrays.

   set J 0
   set K 0
   for { set I 0 } { $I < 4 } { incr I } {
      if { $I != $ooP } {
         set X($J) $D($K) ; incr K
         set Y($J) $D($K) ; incr K
         set Z($J) $D($K) ; incr K
         set V($J) $D($K) ; incr K
         incr J
      } else { 
         set X(3) $D($K) ; incr K
         set Y(3) $D($K) ; incr K
         set Z(3) $D($K) ; incr K
         set V(3) $D($K) ; incr K
      }
   }
}
