package provide TDShock 1.0

# THIS procedure opens all of the UDF data files to be used in the 3D shock
#   study.

proc OpenUDFfiles { SetUpInfo } {
   global tdsANS Pidf0 ExPhi0 ExDa SuN SaT SpiN WinInfo FiLe SInfo

   upvar $SetUpInfo sI
   set Ver 0
   set N 0
   UDFInits

#  OBTAIN the UDF Keys for the used data sets 

   set KeY(0) [GetDataKey CLUSTERII CLUSTER-1 PEACE MOMENTS L1L2]
   set KeY(1) [GetDataKey CLUSTERII CLUSTER-2 PEACE MOMENTS L1L2]
   set KeY(2) [GetDataKey CLUSTERII CLUSTER-3 PEACE MOMENTS L1L2]
   set KeY(3) [GetDataKey CLUSTERII CLUSTER-4 PEACE MOMENTS L1L2]
   set KeY(4) [GetDataKey CLUSTERII CLUSTER-1 AUXILIARY OA CORBT]
   set KeY(5) [GetDataKey CLUSTERII CLUSTER-2 AUXILIARY OA CORBT]
   set KeY(6) [GetDataKey CLUSTERII CLUSTER-3 AUXILIARY OA CORBT]
   set KeY(7) [GetDataKey CLUSTERII CLUSTER-4 AUXILIARY OA CORBT]

#  DO the file opens and and time positions
   
   for { set I 0 } { $I < 4 } { incr I } {
      FileOpen $KeY($I) $Ver $tdsANS(begYr) $tdsANS(begDy) $tdsANS(begHr) \
                             $tdsANS(begMn) $tdsANS(begSc) $tdsANS(endYr) \
                             $tdsANS(endDy) $tdsANS(endHr) $tdsANS(endMn) \
                             $tdsANS(endSc) 
      set kV $KeY($I),$Ver
      if { $SInfo($kV,FSTATUS) == 1 } {
         set OpEn($I) 1 
         FilePos $KeY($I) $Ver $tdsANS(begYr) $tdsANS(begDy) $tdsANS(begHr) \
                                $tdsANS(begMn) $tdsANS(begSc) 
      } else { set OpEn($I) 0 } 
   }

   for { set I 4 } { $I < 8 } { incr I } {
      FileOpen $KeY($I) $Ver $tdsANS(PbegYr) $tdsANS(PbegDy) $tdsANS(PbegHr) \
                             $tdsANS(PbegMn) $tdsANS(PbegSc) $tdsANS(PendYr) \
                             $tdsANS(PendDy) $tdsANS(PendHr) $tdsANS(PendMn) \
                             $tdsANS(PendSc) 
      set kV $KeY($I),$Ver
      if { $SInfo($kV,FSTATUS) == 1 } {
         set OpEn($I) 1 
         FilePos $KeY($I) $Ver $tdsANS(PbegYr) $tdsANS(PbegDy) \
                               $tdsANS(PbegHr) $tdsANS(PbegMn) $tdsANS(PbegSc) 
      } else { set OpEn($I) 0 } 
   }

#  NOW we need to connect units with the sensors.  NOTE that if the 
#     sensor is an auxillary data sensor then use a sensor number of 0.

   set J 0
   for { set I 0 } { $I < 4 } { incr I } {
      ReadPIDF   $KeY($I)
      set sI($J) $KeY($I) ; incr J
      set sI($J) 1 ; set sN $J ; incr J
      set sI($J) [UTILunits $KeY(0),$Ver 1 $sI($sN)] ; incr J
   }
   for { set I 4 } { $I < 8 } { incr I } {
      ReadPIDF   $KeY($I)
      set sI($J) $KeY($I) ; incr J
      set sI($J) 9 ; set sN $J ; incr J
      set sI($J) [UTILunits $KeY($I),$Ver 5 $sI($sN)] ; incr J
      set sI($J) $KeY($I) ; incr J
      set sI($J) 10 ; set sN $J ; incr J
      set sI($J) [UTILunits $KeY($I),$Ver 6 $sI($sN)] ; incr J
      set sI($J) $KeY($I) ; incr J
      set sI($J) 11 ; set sN $J ; incr J
      set sI($J) [UTILunits $KeY($I),$Ver 7 $sI($sN)] ; incr J
   }
}
