package provide TDShock 1.0

# THIS procedure interpolates all the points which make up a given side of
#   the tetrahedron.
#
#  INPUTS:   pW:     the plot window where output is being sent
#            vX:     array of X coordinates of the 4 vertices
#            vY:     array of Y coordinates of the 4 vertices
#            vZ:     array of Z coordinates of the 4 vertices
#            vV:     array of values for the 4 vertices
#            gInfo:  the overlay grid parameters
#            cInfo:  the color conversion parameters
#            nV:     the number of point to include in the interpolate.
#                 3 - just the vertices of the tetrahedron side
#                 4 - include the out of plane vertex

proc FillSide { pW vX vY vZ vV gInfo cInfo { nV 3 } } {
   global GphInfo

   upvar $gInfo gI
   upvar $cInfo cI
   upvar $vX X
   upvar $vY Y
   upvar $vZ Z
   upvar $vV V

   set oP(7) $nV

# DETERMINE the location of the bottom, middle, and top points in the triad 
#     of data

   set vB 1.0e31
   set vT -1.0e31
   for { set I 0 } { $I < 3 }  { incr I } {
      if { $Y($I) < $vB } { set vB $Y($I) ; set OrD(0) $I }
      if { $Y($I) > $vT } { set vT $Y($I) ; set OrD(2) $I }
   }

   switch -exact -- $OrD(0) {
      0  {  if { $OrD(2) == 1 } { set OrD(1) 2 } else { set OrD(1) 1 } }
      1  {  if { $OrD(2) == 0 } { set OrD(1) 2 } else { set OrD(1) 0 } }
      2  {  if { $OrD(2) == 1 } { set OrD(1) 0 } else { set OrD(1) 1 } }
   }

# FORM the slopes and intercepts of the three lines which make up
#   the triangle of points.  The first two lines always radiate from
#   the lowest vertex

    set A(0) [expr ($Y($OrD(0)) - $Y($OrD(2)))/($X($OrD(0)) - $X($OrD(2)))]
    set A(1) [expr ($Y($OrD(0)) - $Y($OrD(1)))/($X($OrD(0)) - $X($OrD(1)))]
    set A(2) [expr ($Y($OrD(2)) - $Y($OrD(1)))/($X($OrD(2)) - $X($OrD(1)))]
    set B(0) [expr $Y($OrD(0)) - $A(0) * $X($OrD(0))]
    set B(1) [expr $Y($OrD(0)) - $A(1) * $X($OrD(0))]
    set B(2) [expr $Y($OrD(1)) - $A(2) * $X($OrD(1))]

# DRAW the connecting lines.  These may be removed after the debug phase 
#   or moved to the end of the routine so that they are drawn over the 
#   interpolated surface.

    PlotColor HOLD $GphInfo(White) OFF
    Line 1 $X(0) $Y(0) 0.0 $X(1) $Y(1) 0.0
    Line 1 $X(0) $Y(0) 0.0 $X(2) $Y(2) 0.0
    Line 1 $X(1) $Y(1) 0.0 $X(2) $Y(2) 0.0

# GET the matrix rows of the vertices.

    TUgridInfo 0 gI rV $X($OrD(0)) $Y($OrD(0))
    set CoL($OrD(0)) $rV(1)
    set RoW($OrD(0)) $rV(2)
    TUgridInfo 0 gI rV $X($OrD(1)) $Y($OrD(1))
    set CoL($OrD(1)) $rV(1)
    set RoW($OrD(1)) $rV(2)
    TUgridInfo 0 gI rV $X($OrD(2)) $Y($OrD(2))
    set CoL($OrD(2)) $rV(1)
    set RoW($OrD(2)) $rV(2)

# DETERMINE half X and Y grid sizes.

    set oP(5) [expr abs(($gI(1) - $gI(0))) / $gI(4) / 2.0]
    set oP(6) [expr abs(($gI(3) - $gI(2))) / $gI(5) / 2.0]

# LOOP over the rows in which the triangle of points falls

   set J 0;
   for { set oP(2) $RoW($OrD(0)) } { $oP(2) <= $RoW($OrD(2)) } { incr oP(2) } {

# FIRST get the center Y value of the row being iterated.  Here the column
#   value being used is really irrelevant.

      TUgridInfo 1 gI rV 0 $oP(2)
      TUgridInfo 20 gI P $rV(0)

# SET if the row contains one of the known points.

      if { $oP(2) == $RoW($OrD($J)) } {
         set oP(3) $CoL($OrD($J))
         set oP(4) $V($OrD($J))
         if { $J == 0 } { 
            set L1 0
            set L2 1
         } else { set L1 0 ; set L2 2 }
         incr J
      } else { set oP(3) -1 ; set oP(4) 0.0 }

# DETERMINE the intersection of this row with the two lines coming out from
#   the lower vertex.  Get the row and column of these intersections. 

      set Yc $P(3) 
      set Xc [expr ($Yc -$B($L1))/$A($L1)]
      TUgridInfo 0 gI pA $Xc $Yc

      set Xc [expr ($Yc -$B($L2))/$A($L2)]
      TUgridInfo 0 gI pB $Xc $Yc

# ORDER the column of the intesections

      if { $pA(1) < $pB(1) } {
         set oP(0) $pA(1) ; set oP(1) $pB(1)
      } else { set oP(0) $pB(1) ; set oP(1) $pA(1) }


# DO the interpolations for the current row

      FillRow  $pW X Y Z V oP gI cI
   }
}
