package provide TDShock 1.0

# THIS procedure finds the center of the tetrahedron and then translates it
#   to the origin.
#
#  INPUTS:  vX:   array of X values for the 4 vertices
#           vY:   array of Y values for the 4 vertices
#           vZ:   array of Z values for the 4 vertices


proc CenterTetra { vX vY vZ } {
  
   upvar $vX X
   upvar $vY Y
   upvar $vZ Z


   set cMx 0.0
   set cMy 0.0
   set cMz 0.0
   for { set I 0 } { $I < 4 } { incr I } {
      set cMx [ expr $cMx + $X($I)]
      set cMy [ expr $cMy + $Y($I)]
      set cMz [ expr $cMz + $Z($I)]
   }

   set cMx [ expr $cMx / 4.0 ]
   set cMy [ expr $cMy / 4.0 ]
   set cMz [ expr $cMz / 4.0 ]

   for { set I 0 } { $I < 4 } { incr I } {
      set X($I) [ expr $X($I) - $cMx]
      set Y($I) [ expr $Y($I) - $cMy]
      set Z($I) [ expr $Z($I) - $cMz]
   }
}
