package provide TDShock 1.0

# THIS gets data from a specified element in the data grids and returns it
#   to the calling environment.

proc Tetrahedron { nE Data } {
   global C1X C1Y C1Z C1V C2X C2Y C2Z C2V C3X C3Y C3Z C3V C4X C4Y C4Z C4V \
          gMOM gPOS tdsANS
         

   upvar $Data D

   TUgridInfo 21 gMOM rV $nE 
   set Tm [TUtimeConv $tdsANS(bT) $rV(2) 2 tdsANS(mBase)]
   set gP [expr int([TUtimeConv $tdsANS(PbT) $Tm 0 tdsANS(mBase)])]
   
   set D(0)  $C1X($gP)
   set D(1)  $C1Y($gP)
   set D(2)  $C1Z($gP)
   set D(3)  $C1V($nE)
   set D(4)  $C2X($gP)
   set D(5)  $C2Y($gP)
   set D(6)  $C2Z($gP)
   set D(7)  $C2V($nE)
   set D(8)  $C3X($gP)
   set D(9)  $C3Y($gP)
   set D(10) $C3Z($gP)
   set D(11) $C3V($nE)
   set D(12) $C4X($gP)
   set D(13) $C4Y($gP)
   set D(14) $C4Z($gP)
   set D(15) $C4V($nE)
}
