package provide TDShock 1.0

# THIS procedure takes one of the tetrahedron sides and puts it into the
#   XY plane.
#
#  INPUTS:  vX:   array of X values for the 4 vertices
#           vY:   array of Y values for the 4 vertices
#           vZ:   array of Z values for the 4 vertices


proc SideToXY { vX vY vZ } {
   global RtoD
  
   upvar $vX X
   upvar $vY Y
   upvar $vZ Z

# LOOP over vertices and put them into vector format. 

   set J 0
   for { set I 0 } { $I < 4 } { incr I } {
      set VeC($J) $X($I) ; incr J
      set VeC($J) $Y($I) ; incr J
      set VeC($J) $Z($I) ; incr J
   }

# GET the normal vector to the plane which is defined through the three
#   points in P0 through P2.  Always select the normal direction  to 
#   point in the positive Z direction.

   TUvecMath VeC - VeC V1 0 3 
   TUvecMath VeC - VeC V2 0 6 
   TUvecMath V1 CROSS V2 Nm
   if { $Nm(2) < 0.0 } { 
       set Nm(0) [expr -$Nm(0)] 
       set Nm(1) [expr -$Nm(1)] 
       set Nm(2) [expr -$Nm(2)] 
   }

# USING a set of EULER angles rotate the normal to lie along +Z.  The Psi
#   rotation undoes the Phi rotation.  

   set Phi [expr atan2 ($Nm(1), $Nm(0)) * $RtoD + 90.0]
   set XY [expr sqrt ($Nm(0) * $Nm(0) + $Nm(1) * $Nm(1))]
   set Theta [expr atan2 ($XY, $Nm(2)) * $RtoD ]
   set Psi [expr -$Phi]

# SET up the rotation matrix

   TUmatrixRot $Phi $Theta $Psi rM EULER

# ROTATE the data points and store them back into their original array
#   postiions.

   set J 0
   for { set I 0 } { $I < 4 } { incr I ; incr J 3 } {
       TUmatrixMath rM * VeC rP 3 3 3 1 0 $J
       if { $I == 0 } { set oZ $rP(2) }
       set X($I) $rP(0) 
       set Y($I) $rP(1) 
       set Z($I) [expr $rP(2) - $oZ]
   }
}
