package provide TDShock 1.0

# THIS establishes the parameters for the 1D grid which is used to hold the
#   moment data and the parameters for the 2D grid which is used in the
#   filling of the tetrahedron sides.  It also does any other parameter
#   setup which may be needed prior to running the program.
#
#  GLOBAL:   gMOM:  The 1D moment grid
#            gTET:  The 2D tetrahedron grid
#            gPOS:  The satellite position grids
 
proc SetUps { } {
   global tdsANS gMOM gTET gPOS

# THE first order of business is the subtract and add a minute to the 
#   requested time.  This is the time used to acquire the satellite position
#   information which is provided on minute centers.  The expansion of the
#   passed in time makes sure that we will get enough measurements to be
#   able to interpolate the satellite position over the time during
#   which we are following the moments.

# FIRST reset the beginning time

   set tdsANS(PbegYr) $tdsANS(begYr)
   set tdsANS(PbegDy) $tdsANS(begDy)
   set tdsANS(PbegHr) $tdsANS(begHr)
   set tdsANS(PbegMn) $tdsANS(begMn)
   set tdsANS(PbegSc) $tdsANS(begSc)
   if { $tdsANS(PbegMn) == 0 } {
      set tdsANS(PbegMn) 59
      if { $tdsANS(PbegHr) == 0 } {
         set tdsANS(PbegHr) 23
         if { $tdsANS(PbegDy) == 1 } {
            incr tdsANS(PbegYr) -1
            set tdsANS(PbegDy) [expr [TUyearLeap $tdsANS(PbegYr)] -1]
         } else { incr tdsANS(PbegDy) -1 }
      } else { incr tdsANS(PbegHr) -1 }
   } else { incr tdsANS(PbegMn) -1 }

# NOW reset the beginning time

   set tdsANS(PendYr) $tdsANS(endYr)
   set tdsANS(PendDy) $tdsANS(endDy)
   set tdsANS(PendHr) $tdsANS(endHr)
   set tdsANS(PendMn) $tdsANS(endMn)
   set tdsANS(PendSc) $tdsANS(endSc)
   if { $tdsANS(PendMn) == 59 } {
      set tdsANS(PendMn) 0
      if { $tdsANS(PendHr) == 23 } {
         set tdsANS(PendHr) 0
         set DoY [TUyearLeap $tdsANS(PendYr)]
         if { $tdsANS(PendDy) == $DoY } {
            incr tdsANS(PendYr) 
            set tdsANS(PendDy) 1
         } else { incr tdsANS(PendDy) }
      } else { incr tdsANS(PendHr) }
   } else { incr tdsANS(PendMn) }

# NOW determine the number of seconds over which the data is being run.

   set bMs [expr $tdsANS(begHr) * 3600000 + $tdsANS(begMn) * 60000 + \
                 1000 * $tdsANS(begSc)]
   set eMs [expr $tdsANS(endHr) * 3600000 + $tdsANS(endMn) * 60000 + \
                 1000 * $tdsANS(endSc)]
   
   set tdsANS(bT) [list $tdsANS(begYr) $tdsANS(begDy) $bMs 0]
   set tdsANS(eT) [list $tdsANS(endYr) $tdsANS(endDy) $eMs 0]

   set dS [TUtimeConv $tdsANS(bT) $tdsANS(eT) 0 tdsANS(mBase)]

# ONCE that is set up determine the number of elements to have in the holding
#    holding grid.

   set nE [expr int($dS / $tdsANS(mRes))]

# OK now define the grid parameters.

   set gMOM(0) [TUtimeConv $tdsANS(bT) $tdsANS(bT) 0 tdsANS(mBase)]
   set gMOM(1) [TUtimeConv $tdsANS(bT) $tdsANS(eT) 0 tdsANS(mBase)]
   set gMOM(2) -1.0
   set gMOM(3) 1.0
   set gMOM(4) $nE
   set gMOM(5) 1
   set gMOM(6) POINT
   set gMOM(7) POINT
   set gMOM(8) COLUMN
   set gMOM(9) KEEP
   set gMOM(10) NEW:ADD:END
   set gMOM(11) -1.0
   set gMOM(12) -1.0e31
   set gMOM(13) -1.0e30
   set gMOM(14) 1.0e30
   set gMOM(15) NO
   set gMOM(16) NO

# SAME for the Position grid 

   set bMs [expr $tdsANS(PbegHr) * 3600000 + $tdsANS(PbegMn) * 60000 + \
                 1000 * $tdsANS(PbegSc)]
   set eMs [expr $tdsANS(PendHr) * 3600000 + $tdsANS(PendMn) * 60000 + \
                 1000 * $tdsANS(PendSc)]
   
   set tdsANS(PbT) [list $tdsANS(PbegYr) $tdsANS(PbegDy) $bMs 0]
   set tdsANS(PeT) [list $tdsANS(PendYr) $tdsANS(PendDy) $eMs 0]

   set dS [TUtimeConv $tdsANS(PbT) $tdsANS(PeT) 0 tdsANS(mBase)]
   set nE [expr int($dS / $tdsANS(mRes))]

   set gPOS(0) [TUtimeConv $tdsANS(PbT) $tdsANS(PbT) 0 tdsANS(mBase)]
   set gPOS(1) [TUtimeConv $tdsANS(PbT) $tdsANS(PeT) 0 tdsANS(mBase)]
   set gPOS(2) -1.0
   set gPOS(3) 1.0
   set gPOS(4) $nE
   set gPOS(5) 1
   set gPOS(6) POINT
   set gPOS(7) POINT
   set gPOS(8) COLUMN
   set gPOS(9) KEEP
   set gPOS(10) NEW:ADD:END
   set gPOS(11) -1.0
   set gPOS(12) -1.0e31
   set gPOS(13) -1.0e30
   set gPOS(14) 1.0e30
   set gPOS(15) NO
   set gPOS(16) NO

# DEFINE the grid parameters used in filling the tetrahedron faces

   set gTET(0) -25.0
   set gTET(1) 25.0
   set gTET(2) -25.0
   set gTET(3) 25.0
   set gTET(4)  91
   set gTET(5)  91
#  set gTET(4) 161
#  set gTET(5) 161
   set gTET(6) POINT
   set gTET(7) POINT
   set gTET(8) COLUMN
   set gTET(9) KEEP
   set gTET(10) NEW:ADD:END
   set gTET(11) 10000.0
   set gTET(12) -1.0e31
   set gTET(13) -1.0e30
   set gTET(14) 1.0e30
   set gTET(15) NO
   set gTET(16) NO

# SET up the skip parameter to use when looping through the grided 
#    tetrahedron data.

   if { $tdsANS(mRes) < $tdsANS(pRes) } { 
       set tdANS(pSkip) [expr int($tdsANS(pRes) / $tdsANS(mRes))]
   } else { set tdsANS(pSkip)  1 }
}
