package provide TDShock 1.0

# THIS procedure turns the graphics on and sets up all the windows that will
#   be used in the plotting of the data.
 
proc PlotOn { tData } {
   global GphInfo tdsANS WinInfo gTET

   upvar $tData tD

# START up the graphics

   GraphicsOn TK ETones

# OPEN a generic window which is scaled in pixels and a square window.  The
#   square window will hold the plots of the filled tetrahedron sides while
#   we can use the generic window to output information in (outside the the
#   tetrahedron data area).

   GenWindow 0 0.0 0.0 0.0 1.0 1.0 1.0 -1.0 -1.0 0. 1.0 1.0 0. XY
   SqWindow 1 0.0 0.0 0.0 1.0 -1.0 -1.0 0. 1.0 1.0 0.

# SET the coordinate format of the four tetrahedron side windows to 1 which
#   means that we can place them using the window scaling of the parent
#   window.

   set WinInfo(2,corFmt) 1
   set WinInfo(3,corFmt) 1
   set WinInfo(4,corFmt) 1
   set WinInfo(5,corFmt) 1

# NEED to determine the limits over which the windows need to be set up. To
#   do this use the first set of data to get the limits and expand those by
#   10% to account for any chnage in the tetrahedron extent.

   set mX -1.0e30
   for { set I 0 } { $I < 4 } { incr I } {
      OrderData tD X Y Z V $I
      CenterTetra X Y Z
      SideToXY X Y Z
      for { set J 0 } { $J < 4 } { incr J } {
         if { [expr abs($X($J))] > $mX } { set mX [expr abs($X($J))] }  
         if { [expr abs($Y($J))] > $mX } { set mX [expr abs($Y($J))] }  
      }
   }

   set mX [expr ceil(1.1 * $mX)]
   set mN [expr -$mX]

   set gTET(0) $mN
   set gTET(1) $mX
   set gTET(2) $mN
   set gTET(3) $mX

# SET up the 4 windows in the filled tetrahedron side data will be drawn

   RelWindow 2 1 -1.0 0.0 0.0 0.0 1.0 0.0  $mN $mN 0. $mX $mX 0.
   DefinePlot 2 2
   RelWindow 3 1 0.0 0.0 0.0 1.0 1.0 0.0   $mN $mN 0. $mX $mX 0.
   DefinePlot 3 3
   RelWindow 4 1 -1.0 -1.0 0.0 0.0 0.0 0.0 $mN $mN 0. $mX $mX 0.
   DefinePlot 4 4
   RelWindow 5 1 0.0 -1.0 0.0 1.0 0.0 0.0  $mN $mN 0. $mX $mX 0.
   DefinePlot 5 5

   set wX [expr $WinInfo(0,p3) + 1]
   set wY [expr $WinInfo(0,p4) + 1]
   if { $wX < $wY } { 
       set Base $wX 
   } else { 
       set Empty [expr $wX - $wY]
       set sL [expr $Empty/2.0] 
       set sX [expr $wY + $sL] 
       set sY 0.0
       set sL [expr $sL *  $wX / $wY]
   }

# SET up the window for the clock

   set WinInfo(6,corFmt) 1
   RelSqWindow 6 0 $sX $sY 0.0 $sL -1. -1. 0. 1. 1. 0.

# Last set the current line color to White.

   PlotColor HOLD $GphInfo(White) OFF
}
