##############################################################################
#                                                                            #
#                           GenDbAsc                                         #
#                                                                            #
##############################################################################

proc GenDbAsc { ToDo { Arch "xxx"} { Comp " "} } {
   global env LsCmD tcl_platform CmdFile IoFile

   set HOME [file join $env(UDFTOOL_HOME) GMenu]
   if {![info exist LsCmD]} {
      source [file join $HOME GSRC GM_SysDeps.tcl]
      GM_SysDeps
   }

   if {![info exist GM_FOpen]} {
      source [file join $HOME GSRC GM_FileChks.tcl]
   }

   if {[string match macintosh* $tcl_platform(platform)] == 1 } {
       set ITimes [AppleScript load \
                   [file join $env(UDF_HOME) bin itimes_scr]]
       set UDFSWAP [AppleScript load \
                   [file join $env(UDF_HOME) bin udf_swap_scr]]
       set UDFTIME [AppleScript load \
                   [file join $env(UDF_HOME) bin udf_time_scr]]
   }

   switch -glob -- $ToDo {
      -I*      { set IFiles 1; set DFiles 0  }
      -D*      { set IFiles 0; set DFiles 1  }
      -A*      { set IFiles 1; set DFiles 1  }
      -F*      { set IFiles 2  
                 set DFiles 2
                 regexp {..(.*)} $ToDo M Fname
               }
      default  { set IFiles 1; set DFiles 1  }
   }

   ###  GET THE CURRENT TIME AS YEAR MONTH DAY  ###

   set dt [clock format [clock seconds] -format %Y%m%d]

   ###  GET THE CURRENT DIRECTORY  ###

   set pwd [pwd]

   ###  REMOVE ANY OLD DATABASE ENTRY FILES  ###

   if { [file exists i.asc] == 1} {
        file delete -force i.asc
   }
   if { [file exists hd.asc] == 1} {
        file delete -force hd.asc
   }

   ###  LIST DIRECTORY AND GET NUMBER OF ENTRIES  ###

   catch [set LsCmD] DL
   set dirlist [split $DL]
   set dirlen [llength $dirlist]
   if {$dirlen == 0} { return }

   ###  BUILD LIST OF ALL VIDF FILES IN THE DIRECTORY ###

   set UDFList ""
   set VIDFS ""
   for {set i 0} { $i < $dirlen } { incr i } {
      set Dname [lindex $dirlist $i]
      if { [string length $Dname] > 0 } {
         set flen [string length $Dname]
         set lastc [string index $Dname [expr $flen - 1]]
         if {[string match $lastc "I"] == 1} {
             lappend VIDFS $Dname
             if { $IFiles == 1 } { lappend UDFList $Dname }
         } elseif {$DFiles == 1 } {
           if {[string match $lastc "D"] == 1} { lappend UDFList $Dname }
         }
      }
   }

   if {$IFiles == 2 } {
      set fd [GM_FOpen stderr $Fname r]
      while { [gets $fd Dname] >= 0 } {
          lappend UDFList $Dname
      }
      close $fd
      file delete -force $Fname
   }

   set numfiles [llength $UDFList]
   set fi [GM_FOpen stderr i.asc w]
   set fhd [GM_FOpen stderr hd.asc w]
   for {set i 0} { $i < $numfiles } { incr i } {
      set Dname [lindex $UDFList $i]
      set flen [string length $Dname]
      set lastc [string index $Dname [expr $flen - 1]]
      set head [string range $Dname 0 [expr $flen - 13]]
      set Iname [lindex $VIDFS [lsearch $VIDFS $head*]]
      set Hname [string range $Dname 0 [expr $flen - 2]]H

      set Ifile [file join $pwd $Iname]
      set Dfile [file join $pwd $Dname]
      set Hfile [file join $pwd $Hname]

      switch -exact -- $lastc {
         I  { puts stderr "PROCESSING VIDF FILE $Dname"
              if {[string match macintosh* $tcl_platform(platform)] == 1 } {
                  set fcmd [GM_FOpen stderr $CmdFile w]
                  puts $fcmd $Dfile
                  close $fcmd
                  GM_FileHere stderr $CmdFile
                  AppleScript run $ITimes 
                  GM_FileHere stderr $IoFile
                  set fio [GM_FOpen stderr $IoFile r]
                  gets $fio Tm
                  close $fio
                  file delete -force $IoFile
              } else {
                set Tm [ exec [file join $env(UDF_HOME) bin itimes] $Dfile]
              }

              set V1 [lindex [split $Tm] 1]
              set V2 [lindex [split $Tm] 2]
              set V3 [lindex [split $Tm] 7]
              set V4 [lindex [split $Tm] 8]
              set V5 [lindex [split $Tm] 9]
              set V6 [lindex [split $Tm] 14]
              puts -nonewline $fi "$head|$V1|$V2|$V3|$V4|$V5|$V6|"
              puts $fi "-1| |$Comp|  |$Arch|$dt"
           }
   
        D  {  puts -nonewline stderr "PROCESSING DATA FILE $Dname  "
              puts -nonewline stderr "\[Testing Byte Order\]  "

              if {[string match macintosh* $tcl_platform(platform)] == 1 } {
                  set fcmd [GM_FOpen stderr $CmdFile w]
                  puts $fcmd $Ifile
                  puts $fcmd $Dfile
                  puts $fcmd $Hfile 
                  close $fcmd
                  GM_FileHere stderr $CmdFile
                  AppleScript run $UDFSWAP 
                  GM_FileHere stderr $IoFile
                  set fio [GM_FOpen stderr $IoFile r]
                  gets $fio result
                  close $fio
                  file delete -force $IoFile
              } else {
                  set result [exec [file join $env(UDF_HOME) bin udf_swap] \
                             $Ifile $Dfile $Hfile ]
              }
   
              if {$result == 1} { 
                  puts stderr "\[Corrected\]"
              } elseif {$result < 0} { 
                  puts stderr "\[Swap Error\]"  
              } else {
                  puts stderr "\[OK\]"  
              }

              if {[string match macintosh* $tcl_platform(platform)] == 1 } {
                  set fcmd [GM_FOpen stderr $CmdFile w]
                  puts $fcmd $Ifile
                  puts $fcmd $Dfile
                  close $fcmd
                  GM_FileHere stderr $CmdFile
                  AppleScript run $UDFTIME 
                  GM_FileHere stderr $IoFile
                  set fio [GM_FOpen stderr $IoFile r]
                  gets $fio Tm
                  close $fio
                  file delete -force $IoFile
              } else {
                  set Tm [exec [file join $env(UDF_HOME) bin udf_time] \
                                      $Ifile $Dfile ]
              }
   
              set V1 [lindex [split $Tm] 0]
              set V2 [lindex [split $Tm] 1]
              set V3 [lindex [split $Tm] 6]
              set V4 [lindex [split $Tm] 7]
              set V5 [lindex [split $Tm] 8]
              set V6 [lindex [split $Tm] 13]
              puts -nonewline $fhd "$head|$V1|$V2|$V3|$V4|$V5|$V6|"
              puts $fhd "-1| |$Comp|  |$Arch|$dt"
           }
   
         default  { continue } 
      }
   }
   close $fi
   close $fhd
   
   GM_FileHere stderr i.asc
   if {[file size i.asc] == 0 } { file delete -force i.asc }
   GM_FileHere stderr hd.asc
   if {[file size hd.asc] == 0 } { file delete -force hd.asc }
}

##############################################################################
#                                                                            #
#                           UpdateDb                                         #
#                                                                            #
##############################################################################


proc UpdateDb { Path Dbase } {
   global env LsCmD CmdFile tcl_platform

   set HOME [file join $env(UDFTOOL_HOME) GMenu]
   if {![info exist LsCmD]} {
      source [file join $HOME GSRC GM_SysDeps.tcl]
      GM_SysDeps
   }

   if {![info exist GM_FOpen]} {
      source [file join $HOME GSRC GM_FileChks.tcl]
   }

   if {[string match macintosh* $tcl_platform(platform)] == 1 } {
       set dBIndex [AppleScript load \
                [file join $env(UDF_HOME) bin db_index_scr]]
       set dBAppend [AppleScript load \
                [file join $env(UDF_HOME) bin db_append_scr] ]
   } 

   set DbPath [file join $Path Database]
   foreach i [list HD I] {
      set dbf [file join $DbPath $Dbase.$i.DBF]
      set ndx [file join $DbPath $Dbase.$i.NDX]
      set asc $i.asc
      set asc [string tolower $asc]
      set asc [file join $DbPath $asc]

      if [file exists $asc] {
         if ![file exists $dbf] {
            puts stderr "No Database for $Dbase ... Created it"
            Db_Create $dbf

            if {[string match macintosh* $tcl_platform(platform)] == 1 } {
                set fcmd [GM_FOpen stderr $CmdFile w]
                puts $fcmd $dbf
                puts $fcmd $ndx
                puts $fcmd V_INST
                puts $fcmd B_YR
                puts $fcmd B_DAY
                puts $fcmd B_MSEC
                close $fcmd
                GM_FileHere stderr $CmdFile
                AppleScript run $dBIndex 
                GM_FileHere stderr $ndx
            } else {
                catch { exec [file join $env(UDF_HOME) bin db_index] \
                                    $dbf $ndx V_INST B_YR B_DAY B_MSEC } OuT
            }
         }

         if {[string match macintosh* $tcl_platform(platform)] == 1 } {
             set fcmd [GM_FOpen stderr $CmdFile w]
              puts $fcmd $dbf
              puts $fcmd $asc
              puts $fcmd $ndx
              close $fcmd
              GM_FileHere stderr $CmdFile
              AppleScript run $dBAppend 
         } else {
              catch { exec [file join $env(UDF_HOME) bin db_append] \
                                    $dbf $asc $ndx } OuT
         }
      }
   }

   if {[file exists [file join $DbPath i.asc]] == 1 } { 
        file delete -force [file join $DbPath i.asc]
   }
   if {[file exists [file join $DbPath hd.asc]] == 1 } { 
        file delete -force [file join $DbPath hd.asc]
   }
}

##############################################################################
#                                                                            #
#                           Db_Create                                        #
#                                                                            #
##############################################################################

proc Db_Create { Dbase } {
    global env LsCmD CmdFile tcl_platform

   set HOME [file join $env(UDFTOOL_HOME) GMenu]
   if {![info exist LsCmD]} {
      source [file join $HOME GSRC GM_SysDeps.tcl]
      GM_SysDeps
   }

   if {![info exist GM_FOpen]} {
      source [file join $HOME GSRC GM_FileChks.tcl]
   }

   if {[string match macintosh* $tcl_platform(platform)] == 1 } {

        set dBCreate [AppleScript load \
                     [file join $env(UDF_HOME) bin db_create_scr] ]
        puts $dBCreate
        set fcmd [GM_FOpen stderr $CmdFile w]
        puts $fcmd $Dbase
        close $fcmd
        GM_FileHere stderr $CmdFile
        AppleScript run $dBCreate 
        GM_FileHere stderr $Dbase
    } else {
        exec [file join $env(UDF_HOME) bin db_create] $Dbase
    }
}

##############################################################################
#                                                                            #
#                           MkBinVidf                                        #
#                                                                            #
##############################################################################

proc MkBinVidf { Vname } {

   global env

   exec $env(UDF_HOME)/bin/mk_idf $Vname
   catch {exec $env(UDF_HOME)/bin/rd_idf ${Vname}I} OutPut
   catch { open RES w }
   if [catch {open RES w} fd ] {
      puts stderr "CANNOT OPEN SYSTEM VIDF DUMP FILE"
   } else {
     puts $fd $OutPut
     close $fd
   }
}
