package provide PkgMgr 1.0

proc PMviewPDE { SrC } {
   global env pdB gI

   set Wb .win$SrC

   if { [string length $pdB(PKG)] == 0 } {
      set MsG [list "PACKAGE DATABASE IS EMPTY"]
      GUIcondPopUp .msgpop -1 -1 $MsG [list OK] V [list Times 16 bold]
      return
   }

   if ![string match VIEW $SrC] {
      set qCmD "PMstateMgr $SrC OFF ; destroy $Wb"
   } else { set qCmD "destroy $Wb" }

# ONLY one open at a time

   if [winfo exists $Wb] { return }

   set gI($SrC.PKG) ""

# OPEN the GUI and set it up

   toplevel $Wb

   if ![string match VIEW $SrC] { PMstateMgr $SrC ON }

   set W1 $Wb.frta
   set W2 $Wb.frtb
   GUIFrame $W1 -1 pack|top||both
   GUIFrame $W2 -1 pack|top||both
   set W2a $W2.a
   set W2b $W2.b
   set W2c $W2.c
   GUIFrame $W2a -1 pack|left||both
   GUIFrame $W2c -1 pack|right
   GUIFrame $W2b -1 pack|right


   set Title "$SrC PACKAGE DATABASE ENTRY"

   GUILabel $W1.title $Title center pack|left|w  8 0 #FFFFFF [list Times 20]
   GUIbuttonPush $W1.quit "QUIT" pack|right|e $qCmD 8

   set PkGs ""
   set nP [llength $pdB(PKG)]
   for { set I 0 } { $I < $nP } { incr I } {
      set diRs [split [lindex $pdB(DIR) $I] "^"]
      set HomE [lindex [split $diRs "+"] 0]
      switch -exact -- $HomE {
         GPH_HOME       { lappend PkGs "[lindex $pdB(PKG) $I] (GH)" }
         UDF_HOME       { lappend PkGs "[lindex $pdB(PKG) $I] (UH)" }
         UDFDOC_HOME    { lappend PkGs "[lindex $pdB(PKG) $I] (UD)" }
         UDFTOOL_HOME   { lappend PkGs "[lindex $pdB(PKG) $I] (UT)" }
         TCLTOOLS_HOME  { lappend PkGs "[lindex $pdB(PKG) $I] (TT)" }
         IDLTOOLS_HOME  { lappend PkGs "[lindex $pdB(PKG) $I] (IT)" }
      }
   }

   set PkGs [lsort -ascii -increasing $PkGs]
   GUILabel $W2a.lgp "PACKAGE" center pack|left|w 
   GUIbuttonMenu $W2a.gp "" pack|left $PkGs "PMgetPDE $W2a $SrC " 8

   if [string match BUILD $SrC] {
      GUIbuttonPush $W2c.doit "BUILD" pack|right "PMpkgBuild ONE" 8
   } elseif [string match DELETE $SrC] { 
      GUIbuttonPush $W2c.doit "DELETE" pack|right "PMpdeAccept $SrC" 8 
   }
}
