##########################################################################
#  PRODUCES a list of all the packages in the database as a function
#     of their base directory
##########################################################################

package provide PkgMgr 1.0

proc PMviewPDB { SrC  } {
   global env pdB sPkG

   set Wb .vpdb$SrC

   set nP [llength $pdB(PKG)]
   if { $nP == 0 } {
      set MsG [list "PACKAGE DATABASE IS EMPTY"]
      GUIcondPopUp .msgpop -1 -1 $MsG [list OK] V [list Times 16 bold]
      return
   }

   if ![string match VIEW $SrC] {
      set qCmD "PMstateMgr M$SrC OFF ; destroy $Wb"
   } else { set qCmD "destroy $Wb" }

# ONLY one open at a time

   if [winfo exists $Wb] { return }

# OPEN the GUI and set it up

   toplevel $Wb

   if ![string match VIEW $SrC] { PMstateMgr M$SrC ON } 

   set W1 $Wb.frta
   set W2 $Wb.frtb
   GUIFrame $W1 -1 pack|top||both
   GUIFrame $W2 -1 pack|top||both
   set W2a $W2.a
   set W2b $W2.b
   set W2c $W2.c
   GUIFrame $W2a -1 pack|left||both
   GUIFrame $W2c -1 pack|right
   GUIFrame $W2b -1 pack|right


   set Title "$SrC MULTIPLE PACKAGE DATABASE ENTRIES"

   GUILabel $W1.title $Title center pack|left|w  8 0 #FFFFFF [list Times 20]
   GUIbuttonPush $W1.quit "QUIT" pack|right|e $qCmD 8

   set HoMeS [list ALL UDF_HOME GPH_HOME UDFTOOL_HOME TCLTOOLS_HOME \
                 IDLTOOLS_HOME UDFDOC_HOME ]

   GUILabel $W2a.lgp "PACKAGE HOME" center pack|left|w 
   GUIbuttonMenu $W2a.gp "" pack|left $HoMeS "PMgetPDB $W2a $SrC " 8

   if [string match BUILD $SrC] {
      GUIbuttonPush $W2c.doit "BUILD" pack|right "PMpkgBuild MANY" 8
   } elseif [string match DELETE $SrC] { 
      GUIbuttonPush $W2c.doit "DELETE" pack|right "PMmultiDelete" 8 
   }
}
