##########################################################################
# THIS routine recreated the package database.  This is done in three
#   ways.  If this is a new entry it will append the entry to the end
#   of the database, creating the database if necessary.  If this is
#   and edited or deleted entry it will rewrite the entire database and
#   either put in the changed entry in place of the current entry or
#   omit it from the database.
##########################################################################

package provide PkgMgr 1.0

proc PMtoPDB { SrC } {
   global env pdB gI

# DO not put an entry into the database which has no defined package

   if { [string length $gI(DBF.PKG)] == 0 } { return }


# SEARCH the database for this package.  If it's already there then this
#    is a replace or a delete ... otherwise its a new entry and can be
#    placed at the end.

   set P [lsearch -exact $pdB(PKG) $gI(DBF.PKG)]
   set nE [llength $gI(pFlds)]
   set nP [llength $pdB(PKG)]

# IF we are deleting and there is only one entry in the database then
#   just nuke the whole thing.

   if { [string match DELETE $SrC] && ($nP == 1) && ($P >= 0) } {
      file delete -force $gI(pdBF)
      ChgOptState EMPTY
      set gI(DBF.$PKG) ""
      return
   }
 
# IF we are here then there is something to do in the database

   if { ($P < 0) && [file exists $gI(pdBF)] } { set oA a } else { set oA w }

   if [catch {open $gI(pdBF) $oA} fd ] {
       puts stderr "CANNOT OPEN/CREATE $gI(pdBF)"
       exit
   }

   if { $oA == "w" } {
      set FlDs [lindex $gI(pFlds) 0]
      for { set I 1 } { $I < $nE } { incr I } {
          append FlDs +[lindex $gI(pFlds) $I]
      }
      puts $fd "FIELDS: $FlDs"
   }

   if { $P < 0 } {
      puts $fd "struct $gI(DBF.PKG) \{"
      for { set I 0 } { $I < $nE } { incr I } {
         set fD [lindex $gI(pFlds) $I]
         if { [string length $gI(DBF.$fD)] > 0 } {
            set LiNe [format "   %-8s %s" $fD $gI(DBF.$fD)]
            puts $fd $LiNe
         }
      }
      puts $fd "\}"
   } else {
      for { set J 0 } { $J < $nP } { incr J } {
         if { $J == $P } {
            if ![string match DELETE $SrC] {
                puts $fd "struct $gI(DBF.PKG) \{"
                for { set I 0 } { $I < $nE } { incr I } {
                   set fD [lindex $gI(pFlds) $I]
                   if { [string length $gI(DBF.$fD)] > 0 } {
                      set LiNe [format "   %-8s %s" $fD $gI(DBF.$fD)]
                      puts $fd $LiNe
                   }
                }
                puts $fd "\}"
            }
         } else {
             puts $fd "struct [lindex $pdB(PKG) $J] \{"

             for { set I 0 } { $I < $nE } { incr I } {
                set fD [lindex $gI(pFlds) $I]
                if { [string length [lindex $pdB($fD) $J] ] > 0 } {
                   set LiNe [format "   %-8s %s" $fD [lindex $pdB($fD) $J ]]
                   puts $fd $LiNe
                }
             }
             puts $fd "\}"
         }
      }
   }


   close $fd
}
