##########################################################################
# THIS routine performs three functions.  It can initializes an empty 
#   package database entry in the GUI format, convert a normal database
#   entry to the GUI format, or convert a GUI format database entry
#   to the normal format.  When going from normal to GUI dBPkg is the
#   package name of the entry to convert.  When going in the opposite
#   direction it is the converted package entry.
##########################################################################

package provide PkgMgr 1.0

proc PMsetPDE { S AcTioN { PkG "" } } {
   global env pdB gI

   switch -exact -- $AcTioN {
      INITIALIZE {
         set gI($S.PKG)  ""
         set gI($S.REV)  ""
         set gI($S.DIR0) ""
         set gI($S.DIR1) ""
         set gI($S.DIR2) ""
         set gI($S.OPT0)  0 ; set gI($S.OPT1) "" ; set gI($S.OPT2)  0 
         set gI($S.OPT3) "" ; set gI($S.OPT4)  0 ; set gI($S.OPT5)  1
         set gI($S.OPT6)  0 ; set gI($S.OPT7)  0 ; set gI($S.OPT8) ""
         set gI($S.ENV)  ""
         set gI($S.PTS)  ""
         set gI($S.DEP)  ""
         set gI($S.SCMD) ""
         set gI($S.RCMP) ""
         set gI($S.PFMT) ""
         set gI($S.WPTS) ""
         set gI($S.WDEP) ""
      }
      TOGUI {

         set Pieces [ list ENV PTS DEP RCMP WPTS WDEP]

         set P [lsearch -exact $pdB(PKG) $PkG]
         set gI($S.PKG)  [lindex $pdB(PKG) $P]
         set gI($S.REV)  [lindex $pdB(REV) $P]

         set diRs [split [lindex $pdB(DIR) $P] "^"]
         set dInFo [split [lindex $diRs 0] "+"]
         set nE [llength $dInFo]
         if { $nE > 0 } {
            set gI($S.DIR0)  [lindex $dInFo 0]
            set gI($S.DIR1) ""
            for { set I 1 } { $I < $nE } { incr I } {
               lappend gI($S.DIR1) [lindex $dInFo $I]
            }
         }
         set nE [llength $diRs]
         set gI($S.DIR2) ""
         for { set I 1 } { $I < $nE } { incr I } {
            lappend gI($S.DIR2) [lindex $diRs $I]
         }


         set oPs [split [lindex $pdB(OPT) $P] "|"]
         set nE [llength $oPs]
         for { set I 0 } { $I < $nE } { incr I } {
            set gI($S.OPT$I) [lindex $oPs $I]
         }

         set OptDef [list 0 "" 0 "" 0 1 0 0 ""]
         for {  } { $I < 9 } { incr I } {
            set gI($S.OPT$I) [lindex $OptDef $I]
         }

         set Elem [split $gI($S.OPT3) "+"]
         set nE [llength $Elem]
         set gI($S.OPT3) ""
         for { set I 0 } { $I < $nE } { incr I } {
            lappend gI($S.OPT3) [lindex $Elem $I]
         }

         set Elem [split $gI($S.OPT8) "+"]
         set nE [llength $Elem]
         set gI($S.OPT8) ""
         for { set I 0 } { $I < $nE } { incr I } {
            lappend gI($S.OPT8) [lindex $Elem $I]
         }

         set nP [llength $Pieces]
         for { set J 0 } { $J < $nP } { incr J } {
             set IndX [lindex $Pieces $J]
             set Elem [split [lindex $pdB($IndX) $P] "+"]
             set nE [llength $Elem]
             set gI($S.$IndX) ""
             for { set I 0 } { $I < $nE } { incr I } {
                lappend gI($S.$IndX) [lindex $Elem $I]
             }
         }

         set gI($S.SCMD) [lindex $pdB(SCMD) $P]
         set gI($S.PFMT) [lindex $pdB(PFMT) $P]

      }
      FROMGUI {
         set D DBF
         set Pieces [ list ENV PTS DEP RCMP WPTS WDEP]

         set gI($D.PKG) $gI($S.PKG)
         set gI($D.REV) $gI($S.REV)

         set gI($D.DIR) $gI($S.DIR0)
         set nD [llength $gI($S.DIR1)]
         for { set I 0 } { $I < $nD } { incr I } {
            set dIR [string trim [lindex $gI($S.DIR1) $I]]
            append gI($D.DIR) +$dIR
         }

         set nD [llength $gI($S.DIR2)]
         for { set I 0 } { $I < $nD } { incr I } {
            set dIR [string trim [lindex $gI($S.DIR2) $I]]
            append gI($D.DIR) ^$dIR
         }

         set gI($D.OPT) $gI($S.OPT0)|$gI($S.OPT1)|$gI($S.OPT2)|

         set nD [llength $gI($S.OPT3)]
         if { $nD > 0 } {
            set TmP [string trim [lindex $gI($S.OPT3) 0]]
            for { set I 1 } { $I < $nD } { incr I } {
               set File [string trim [lindex $gI($S.OPT3) $I]]
               append TmP +$File
            }
         } else { set TmP "" }

         append gI($D.OPT) ${TmP}|
         append gI($D.OPT) $gI($S.OPT4)|$gI($S.OPT5)|$gI($S.OPT6)|$gI($S.OPT7)

         set nD [llength $gI($S.OPT8)]
         if { $nD > 0 } {
            set TmP [string trim [lindex $gI($S.OPT8) 0]]
            for { set I 1 } { $I < $nD } { incr I } {
               set File [string trim [lindex $gI($S.OPT8) $I]]
               append TmP +$File
            }
         } else { set TmP "" }
         append gI($D.OPT) |${TmP}

         set nP [llength $Pieces]
         for { set J 0 } { $J < $nP } { incr J } {
            set IndX [lindex $Pieces $J]
            set nD [llength $gI($S.$IndX)]
            if { $nD > 0 } {
               set gI($D.$IndX) [string trim [lindex $gI($S.$IndX) 0]]
               for { set I 1 } { $I < $nD } { incr I } {
                  set Elem [string trim [lindex $gI($S.$IndX) $I]]
                  append gI($D.$IndX) +$Elem
               }
            } else { set gI($D.$IndX) "" }
         }

         set gI($D.SCMD) $gI($S.SCMD)
         set gI($D.PFMT) $gI($S.PFMT)
      }
   }
}
