##########################################################################
# THIS routine reads in the package database
##########################################################################

package provide PkgMgr 1.0

proc PMreadPDB { } {
   global env pdB gI

# IF there is no database then set the packge field to empty and return
#    as if the database has been read.

   if ![file exists $gI(pdBF)] {
      set pdB(PKG) ""
      return 1
   }

# OPEN the package database file

   if [catch {open $gI(pdBF) r} fd ] {
      puts stderr "CANNOT OPEN $gI(pdBF)"
      return 0
   }
                                                                                
# READ the field information.  This tells us what fields may be defined in 
#   a package definition
                                                                                
   gets $fd LiNe
   set fLd $gI(pFlds)
   set fL [llength $fLd]
   set pdB(PKG) ""
   for { set I 0 } { $I < $fL } { incr I } {set pdB([lindex $fLd $I]) ""}
                                                                                
# READ the entire database information.  This is stored as a set of lists 
#    in the dbE array.  Each package definition has the format 
#
#  struct PACKAGE {
#  }
# 
#  with the PACKAGE definition within the {}.
                                                                                
   while { [gets $fd LiNe] >= 0 } {
      scan $LiNe "%s %s %s" sB PKG sP 
      set Fld [string trim $sB]
      set Entry [string trim $PKG]
      if { [string compare struct $sB] == 0 } { 
         for { set I 0 } { $I < $fL } { incr I } { 
            set CuR([lindex $fLd $I]) "" 
         }
         lappend pdB(PKG) $PKG
         set EoF [gets $fd LiNe] 
         scan $LiNe "%s %s" Fld Entry 
         set Fld [string trim $Fld]
         set Entry [string trim $Entry]
         while { ([string match $Fld "\}" ] == 0) && ($EoF >= 0) } {
            set CuR($Fld) $Entry
            set EoF [gets $fd LiNe] 
            scan $LiNe "%s %s" Fld Entry 
            set Fld [string trim $Fld]
            set Entry [string trim $Entry]
         }
      } else { continue }
      for { set I 0 } { $I < $fL } { incr I } { 
         set F [lindex $fLd $I]
         lappend pdB($F) $CuR($F)
      }
   }

   close $fd

   return 1
}
