##########################################################################
# THIS builds a UDF software package.  It is placed in the packages
#   base directory under the PKGS directory.
##########################################################################

package provide PkgMgr 1.0

proc PMpkgBuild { SrC } {
   global env pdB gI SySCmDs sPkG

   set cwd [pwd]

###########################################################################
#  BUILD the build list
###########################################################################

   if [string match MANY $SrC] {
      set InDx [array names sPkG] 
      set bList ""
      set nB [llength $InDx]
      for { set I 0 } { $I < $nB } { incr I } {
         set pName [lindex $InDx $I]
         if { $sPkG($pName) == 1 } { lappend bList $pName }
      }
   } else { set bList [list $gI(CURBUILD)] }

###########################################################################
#  NUMBER of packages to be built and package loop
###########################################################################

   set nB [llength $bList]
   for { set K 0 } { $K < $nB } { incr K } {

###########################################################################
#  THIS is the location of the package information in the package database
#     lists
###########################################################################

       set pName [lindex $bList $K]
       set P [lsearch $pdB(PKG) $pName]

###########################################################################
#   SET up the directory information that will be needed
###########################################################################

       set pRev [lindex $pdB(REV) $P ]
       set dDir [split [lindex $pdB(DIR) $P] "^"]
       set dNames [split [lindex $dDir 0] "+"]
       set sDir $env([lindex $dNames 0])
       set pH $env([lindex $dNames 0])
       set dLen [llength $dNames]
       for { set I 1 } { $I < $dLen } { incr I } {
          set sDir [file join $sDir [lindex $dNames $I]]
       }

###########################################################################
# HEAD to the package directory
###########################################################################

       cd $sDir

###########################################################################
# THIS is the name of the package that we will be building less the .tgz
#    and a list of the files that are included in that package.
###########################################################################

       set rName $pName.$pRev 
       set tName(0) $pName.$pRev 
       set ToTar(0) [PMpkgManifest [lindex $pdB(PTS) $P]]

###########################################################################
#  Get the same thing if there is a WINDOWS specific package which
#     goes along with this package.
###########################################################################

       if { [string length [lindex $pdB(WPTS) $P] ] > 0 } {
           set tB 2
           set tName(1) $pName.$pRev.WIN32B
           set ToTar(1) [PMpkgManifest [lindex $pdB(WPTS) $P]]
       } else { set tB 1 }


############################################################################
#  NOW is as good a time as any to create the PKGS directory if it doesn't
#     already exist.
###########################################################################

       set pHome [file join $pH PKGS]
       if ![file isdirectory $pHome] { file mkdir $pHome }

###########################################################################
#  IF we need to delete previous versions do that now.  This will get
#     both the generic and WINDOWS builds should such exist.
###########################################################################

       if $gI(opPDE) {
          set fNames [exec $SySCmDs(ls) $pHome ]
          set nP [llength $fNames] 
          for { set I 0 } { $I < $nP } { incr I } {
              set fN [lindex [split [lindex $fNames $I] "."] 0]
              if { [string compare $fN $pName] == 0 } {
                 file delete -force [file join $pH PKGS [lindex $fNames $I]]
                 set gI(OLDBUILD) [file rootname [lindex $fNames $I]]
                 PMmsgWin OLDBUILD
              }
          }
       }

############################################################################
#  NOW loop over the builds which will be 1 if there is no WINDOWS specific
#    build and 2 if there is
############################################################################

       for { set L 0 } { $L < $tB } { incr L } {
          cd $sDir

###########################################################################
# TAR them all together and put the tar file into the PKGS directory
#    under the package home.  NOTE: tar and gzip are done separately for
#    those not using the GNU tar.
###########################################################################

          set ToTar($L) [string trim $ToTar($L)]
          eval exec tar -cf $rName.tar $ToTar($L)
          eval exec gzip -f $rName.tar 
          file rename -force $rName.tar.gz [file join $pH PKGS $rName.tgz]

###########################################################################
#  CREATE the database portion of the package
###########################################################################

          PMpkgPDE $pH $rName $P $L

###########################################################################
# COMBINE the database and file parts of the package together
###########################################################################

          cd [file join $pH PKGS]

          eval exec tar -cf $tName($L).tar $rName.tgz $rName.dbe
          file delete -force $rName.dbe
          file delete -force $rName.tgz

          set gI(CURBUILD) $tName($L)
          PMmsgWin BUILD
       }

###########################################################################
# BACK to where we started.
###########################################################################

       cd $cwd
    }
}
