##########################################################################
# THIS routine will either allow a package database entry to be filled in 
#    or to be edited. 
##########################################################################

package provide PkgMgr 1.0

proc PMpdbPDE { SrC } {
   global env pdB gI 

# YOU can only open one of these windows at a time to prevent users from
#   doing something crazy like editiing and deleting the same entry.

   set Wb .entry
   if [winfo exists $Wb] { return }

# SOME of lists used in options and other things in setting up the GUI

   set OptA  [list "NO" "YES" "YES TO SHARED LIBRARY"]
   set OptNY [list "NO" "YES"] 
   set OptYN [list "YES" "NO"] 
   set OptB  [list "NO" "BEFORE MAKE CALL" "AFTER MAKE CALL"]
   set OptC  [list "UDF_HOME" "GPH_HOME" "UDFTOOL_HOME" "TCLTOOLS_HOME" \
                   "IDLTOOLS_HOME" UDFDOC_HOME]

   set OptL  [list "NEEDS COMPILING" "LINK COMMAND" "NEEDS TO RELEASE" \
                   "FILES MOVED TO bin" "NEEDS pkg_mkIndex" \
                   "PURGE OLD INSTALL" "INSTALL IF EXISTS" \
                   "USES AUpkgSpecial" "WINDOWS EXTENSIONS"]

   set OptT [list M|OptA E|25 T|OptNY E|25 T|OptNY T|OptNY T|OptYN M|OptB E|25]

# OPEN the GUI and set it up

   toplevel $Wb

   set W $Wb.f$SrC
   GUIFrame $W -1 pack|top

   PMstateMgr $SrC ON
   PMsetPDE $SrC INITIALIZE ""
   set RoW 0

   set Title "$SrC PACKAGE DATABASE ENTRY"
   GUILabel $W.title $Title center grid|$RoW|0|w||3  8 0 \
          #FFFFFF [list Times 20]
   GUIbuttonPush $W.quit "QUIT" grid|$RoW|3|e \
                                      "PMstateMgr $SrC OFF ; destroy $Wb" 8
   incr RoW

   GUIblankRow $W $RoW 1.0 ; incr RoW

# ONLY edit and delete options need to pick an entry from those in the
#   database

   if ![string match NEW $SrC] {
      if { [string length $pdB(PKG)] == 0 } {
         set MsG [list "PACKAGE DATABASE IS EMPTY"]
         GUIcondPopUp .msgpop -1 -1 $MsG [list OK] V [list Times 16 bold]
         PMstateMgr $SrC OFF
         destroy $Wb
         return
      }

      set PkGs ""
      set nP [llength $pdB(PKG)]
      for { set I 0 } { $I < $nP } { incr I } {
         set diRs [split [lindex $pdB(DIR) $I] "^"]
         set HomE [lindex [split $diRs "+"] 0]
         switch -exact -- $HomE {
            GPH_HOME       { lappend PkGs "[lindex $pdB(PKG) $I] (GH)" }
            UDF_HOME       { lappend PkGs "[lindex $pdB(PKG) $I] (UH)" }
            UDFDOC_HOME    { lappend PkGs "[lindex $pdB(PKG) $I] (UD)" }
            UDFTOOL_HOME   { lappend PkGs "[lindex $pdB(PKG) $I] (UT)" }
            TCLTOOLS_HOME  { lappend PkGs "[lindex $pdB(PKG) $I] (TT)" }
            IDLTOOLS_HOME  { lappend PkGs "[lindex $pdB(PKG) $I] (IT)" }
         }
      }
      set PkGs [lsort -ascii -increasing $PkGs]

      GUILabel $W.lgp "PACKAGE" center grid|$RoW|0|w 
      GUIbuttonMenu $W.gp "" grid|$RoW|1|w $PkGs "PMgetPDE $W $SrC " 6
      incr RoW
   }

   GUIblankRow $W $RoW 1.0 ; incr RoW

   GUILabel $W.lpn "PACKAGE NAME" center grid|$RoW|0|w 
   GUIboxEntry $W.pn grid|$RoW|1|w||2 20 gI($SrC.PKG)  
   incr RoW

   GUILabel $W.lpr "PACKAGE REVISION" center grid|$RoW|0|w 
   GUIboxEntry $W.pr grid|$RoW|1|w||2 20 gI($SrC.REV)  
   incr RoW

   GUIblankRow $W $RoW 1.0 ; incr RoW

   GUILabel $W.lph "PACKAGE DIRECTORY INFORMATiON" center grid|$RoW|0|w||2 \
             8 0 #FFFFFF 
   incr RoW

   GUIblankRow $W $RoW 0.5 ; incr RoW

   GUILabel $W.lbd "1. BASE DIRECTORY PATH" center grid|$RoW|0|w 
   GUIbuttonMenu $W.bd "" grid|$RoW|1|w||2 $OptC \
           "GUIoptsProcess $W.bd gI($SrC.DIR0) PRI " 6
   incr RoW
 
   GUILabel $W.lhd "2. HOME DIECTORY" center grid|$RoW|0|w 
   GUIboxEntry $W.hd grid|$RoW|1|w||2 25 gI($SrC.DIR1)  
   incr RoW

   GUILabel $W.lsd "3. SUBDIRECTORIES" center grid|$RoW|0|w 
   GUIboxEntry $W.sd grid|$RoW|1|w||2 25 gI($SrC.DIR2)  
   incr RoW

   GUIblankRow $W $RoW 1.0 ; incr RoW

   GUILabel $W.lpo "INSTALL OPTIONS" center grid|$RoW|0|w||2 8 0 #FFFFFF 
   incr RoW

   GUIblankRow $W $RoW 0.5 ; incr RoW

   set nO [llength $OptL]
   for { set I 0 } { $I < $nO } { incr I } {
      set LaB "[expr $I + 1]. [lindex $OptL $I]"
      set oI [split [lindex $OptT $I] "|"]

      GUILabel $W.l$I $LaB center grid|$RoW|0|w 
      switch -exact -- [lindex $oI 0] {
         T { 
            upvar 0 [lindex $oI 1] oPs 
            GUIbuttonToggle $W.o$I "" grid|$RoW|1|w||2 \
                   $OptNY "GUIoptsToggle $W.o$I gI($SrC.OPT$I) ALT " 6
            $W.o$I configure -text [lindex $oPs $gI($SrC.OPT$I)] 
         }
         M { 
            upvar 0 [lindex $oI 1] oPs 
            set oL [lindex $oPs $gI($SrC.OPT$I)] 
            GUIbuttonMenu $W.o$I "" grid|$RoW|1|w||2 $oPs \
                   "GUIoptsProcess $W.o$I gI($SrC.OPT$I) ALT " 6
            $W.o$I configure -text [lindex $oPs $gI($SrC.OPT$I)] 
         }
         E { GUIboxEntry $W.o$I grid|$RoW|1|w||2 [lindex $oI 1] gI($SrC.OPT$I) }
      }
      incr RoW
   }

   GUIblankRow $W $RoW 1.0 ; incr RoW

   GUILabel $W.lev "ENVIRONMENT VARIABLES" center grid|$RoW|0|w 
   GUIboxEntry $W.ev grid|$RoW|1|w||2 30 gI($SrC.ENV)  
   incr RoW

   GUILabel $W.lip "FILE MANIFEST" center grid|$RoW|0|w 
   GUIboxEntry $W.ip grid|$RoW|1|w||2 30 gI($SrC.PTS)  
   incr RoW

   GUILabel $W.lpd "DEPENDENCY LIST" center grid|$RoW|0|w 
   GUIboxEntry $W.pd grid|$RoW|1|w||2 30 gI($SrC.DEP)  
   incr RoW

   GUILabel $W.lsi "USE SPECIAL INSTALLER" center grid|$RoW|0|w 
   GUIboxEntry $W.si grid|$RoW|1|w||2 20 gI($SrC.SCMD)  
   incr RoW

   GUILabel $W.lrc "RECOMPILE WHEN UPDATING" center grid|$RoW|0|w 
   GUIboxEntry $W.rc grid|$RoW|1|w||2 20 gI($SrC.RCMP)  
   incr RoW

   GUIblankRow $W $RoW 1.0 ; incr RoW

   GUILabel $W.lwo "WINDOWS PACKAGE ALTERNATIVES" center \
       grid|$RoW|0|w||2 8 0 #FFFFFF 
   incr RoW

   GUIblankRow $W $RoW 0.5 ; incr RoW

   GUILabel $W.lwip "FILE MANIFEST" center grid|$RoW|0|w 
   GUIboxEntry $W.wip grid|$RoW|1|w||2 30 gI($SrC.WPTS)  
   incr RoW

   GUILabel $W.lwdp "DEPENDENCY LIST" center grid|$RoW|0|w 
   GUIboxEntry $W.wdp grid|$RoW|1|w||2 30 gI($SrC.WDEP)  
   incr RoW

   GUIblankRow $W $RoW 1.5 ; incr RoW

   GUIbuttonPush $W.chk "CHECK"  grid|$RoW|1|e "PMmsgWin CHECK.$SrC" 8
   GUIbuttonPush $W.done "SAVE" grid|$RoW|2|w "PMpdeAccept $SrC" 8
   GUIbuttonPush $W.uwb "SAVE/BUILD" grid|$RoW|3|w "PMpdeAccept $SrC.WB" 8
}
