##########################################################################
#  USE this to spit out messages such as what's been built or updated.
##########################################################################

package provide PkgMgr 1.0

proc PMmsgWin { SrC } {
   global env gI

   set SrC [split $SrC "."]
   set Wb .msgWIN
   if ![winfo exists $Wb] { 
       toplevel $Wb
                                                                                
       set W $Wb.fra
       GUIFrame $W -1 pack|top
                                                                                
       set RoW 0
                                                                                
       set Title "STATUS WINDOW"
       GUILabel $W.title $Title center grid|$RoW|0|w||1  8 0 \
                   #FFFFFF [list Times 20]
       GUIbuttonPush $W.clear "CLEAR" grid|$RoW|1|e \
              ".msgWIN.fra.chk delete 0.0 end" 8
       GUIbuttonPush $W.quit "QUIT" grid|$RoW|2|e "destroy $Wb" 8
       incr RoW

       GUIboxText $W.chk 80 20 grid|$RoW|0|w||3 0 1

       set tW $W.chk
       $tW tag configure black -foreground black
       $tW tag configure white -foreground white
       $tW tag configure red -foreground red
       $tW tag configure orange -foreground orange
   }

   set W $Wb.fra
   set tW $W.chk
   switch -exact -- [lindex $SrC 0] {
      NEW {
         if { [string length $gI(CUR$SrC)] > 0 } {
            $tW insert end "ENTRY $gI(CUR$SrC) added to database\n"
            set gI(CUR$SrC) ""
         }
      }
      EDIT {
         if { [string length $gI(CUR$SrC)] > 0 } {
            $tW insert end "ENTRY $gI(CUR$SrC) replaced in database\n"
            set gI(CUR$SrC) ""
         }
      }
      DELETE {
         if { [string length $gI(CUR$SrC)] > 0 } {
            $tW insert end "ENTRY $gI(CUR$SrC) deleted from database\n"
            set gI(CUR$SrC) ""
         }
      }
      BUILD {
         if { [string length $gI(CUR$SrC)] > 0 } {
            $tW insert end "BUILT package $gI(CUR$SrC)\n"
            set gI(CUR$SrC) ""
         }
      }
      OLDBUILD {
         if { [string length $gI($SrC)] > 0 } {
            $tW insert end "DELETED old build $gI($SrC)\n" red 
            set gI($SrC) ""
         }
      }
      CHECK {
         set D DBF
         PMsetPDE [lindex $SrC 1] FROMGUI 
         $tW insert end "\nCHECKING PACKAGE $gI(CUREDIT)\n" orange
         $tW insert end "PACKAGE NAME DEFINED ... "
             if { [string length $gI($D.PKG)] == 0 } { 
             $tW insert end "NO!\n" red 
         } else { $tW insert end "YES\n" white }

         $tW insert end "PACKAGE REVISION DEFINED ... "
         if { [string length $gI($D.REV)] == 0 } { 
             $tW insert end "NO!\n" red 
         } else { $tW insert end "YES\n" white }
 
         set diRs [split $gI($D.DIR) "^"]
         set dInFo [split [lindex $diRs 0] "+"]
         set nE [llength $dInFo]

         set pDir 0
         if { $nE > 0 } {
            set pHoMe $env([lindex $dInFo 0])
            for { set I 1 } { $I < $nE } { incr I } {
               set pHoMe [file join $pHoMe [lindex $dInFo $I]]
            }

            $tW insert end "CHECKING FOR DIRECTORY $pHoMe ... "
            if [file isdirectory $pHoMe] {
               $tW insert end "EXISTS\n" white
               set pDir 1
            } else { $tW insert end "MISSING!\n" red }
   
            set nE [llength $diRs]
            if { $nE > 1 } {
               for { set I 1 } { $I < $nE } { incr I } {
                  set sHoMe [file join $pHoMe [lindex $diRs $I]]
                  $tW insert end "CHECKING FOR SUBDIRECTORY $sHoMe ... "
                  if [file isdirectory $sHoMe] {
                     $tW insert end "EXISTS\n" white
                  } else { $tW insert end "MISSING!\n" red }
               }
            }
         } else { $tW insert end "HOME DIRECTORY is NOT SET\n" red }

         if $pDir {
            set MvS [lindex [split $gI($D.OPT) "|"] 3]
            set MvP [split $MvS "+"]
            set nE  [llength $MvP]
            if { $nE > 0 } {
               for { set I 0 } { $I < $nE } { incr I } {
                  set mvFile [file join $pHoMe [lindex $MvP $I] ]
                  $tW insert end "CHECKING FOR FILE $mvFile ... "
                  if [file exists $mvFile] {
                     $tW insert end "EXISTS\n" white
                  } else { $tW insert end "MISSING!\n" red }
               }
            }

            set MvS [lindex [split $gI($D.OPT) "|"] 8]
            set MvP [split $MvS "+"]
            set nEa [llength $MvP]
            $tW insert end "FILE MOVE/EXTENSION CONSISTANCY CHECK ... "
            if { ($nEa > 0) && ($nEa != $nE) } {
               $tW insert end "FAILED ($nE Files, $nEa Extensions)\n" red
            } else { $tW insert end "PASSED\n" white }
         }

         set EnV [split $gI($D.ENV) "+"]
         set nE  [llength $EnV]
         if { $nE > 0 } {
            for { set I 0 } { $I < $nE } { incr I } {
               set eV [lindex $EnV $I]
               $tW insert end "ENVIRONMENT VARIABLE $eV SET LOCALLY ... "
               if [info exists env($eV)] {
                  $tW insert end "YES\n" white
               } else { $tW insert end "NO!\n" red }
            }
         } else { $tW insert end "NO REQUIRED ENVIRONMENT VARIABLES\n" red }

         
         for { set L 0 } { $L < 2 } { incr L } {
            if { $L == 0 } { set V PTS } else { set V WPTS }
            set FilE [split $gI($D.$V) "+"]
            set nE  [llength $FilE]
            if { $nE > 0 } {
               if $pDir {
                  $tW insert end "\nCHECKING $V ELEMENTS\n"
                  for { set I 0 } { $I < $nE } { incr I } {
                     set pT [split [lindex $FilE $I] ":"]
                     set nD [expr [llength $pT] - 1]
                     set pK [lindex $pT $nD]

                     if { [string first "*" $pK] == -1 } {
                        set pD $pHoMe
                        for { set J 0 } { $J < $nD } { incr J } {
                           set pD [file join $pD [lindex $pT $J] ]
                           $tW insert end "   CHECK FOR DIRECTORY $pD ... "
                           if [file isdirectory $pD] {
                              $tW insert end "EXISTS\n" white
                           } else { $tW insert end "MISSING!\n" red }
                        }
                        if { [string length $pK] > 0 } {
                           set fName [file join $pD $pK ]
                           $tW insert end "   CHECK FOR FILE $fName ... "
                           if [file exists $fName] {
                              $tW insert end "EXISTS\n" white
                           } else { $tW insert end "MISSING!\n" red }
                        }
                     }
                  } 
               }
            } else { 
                if { $L == 0 } { $tW insert end "EMPTY FILE LIST\n" red } 
            }
         }
         $tW insert end "CHECK COMPLETE\n" orange
      }
   }
}
