#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"

ByTe_1 *Xfr (void *PIDF, ByTe_1 *V, ByTe_2 Post, ByTe_2 N) 
{
   struct Pidf *P;

   register ByTe_1 *c1, *c2, *cEnD;
   register ByTe_2 *s1, *s2, *sEnD;
   
   ByTe_2 Len;
   ByTe_1 *Kp;

   P = (struct Pidf *) PIDF;                     /* PIDF interface structure */
 
   if (Post == ONEBYTE) {                        /* text transfer            */
      Len = (N == 0) ? strlen(V) + 1 : N;        /* length to store          */
      ChkPidfMem (PIDF, Post, Len);              /* check memory             */
      c1 = (ByTe_1 *)P->CMisc + P->NFCMisc;      /* point to next free byte  */
      Kp = c1;                                   /* return pointer           */
      cEnD = c1 + Len;                           /* end of data to store     */
      for (c2 = V; c1 < cEnD; )                  /* xfer loop                */
         *c1++ = *c2++;                          /* xfer data                */
      P->NFCMisc += Len;                         /* next free byte point     */
   } else {                                      /* TWO BYTE TRANSFER        */
      ChkPidfMem (PIDF, Post, N);                /* check memory             */
      Kp = (ByTe_1 *)P->SMisc + sizeof(ByTe_2) * P->NFSMisc;  /* return ptr  */
      s1 = (ByTe_2 *)P->SMisc + P->NFSMisc;      /* point to next free short */
      sEnD = s1 + N;                             /* end of data to store     */
      for (s2 = (ByTe_2*)V; s1 < sEnD; )         /* xfer loop                */
         *s1++ = *s2++;                          /* xfer data                */
      P->NFSMisc += N;                           /* next free byte point     */
   }                                             /* END ONE BYTE TRANSFER    */

  return (Kp);                                   /* return pointer to text   */
}
