#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"

void PtrUpDate (void *PIDF, ByTe_2 UpDate) 
{
   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfSensor *Px;
   struct PidfAnc *Pa;
   struct PidfMode *Pm;
   struct PidfLatLong *Pl;

   register ByTe_4 D, I;

   ByTe_1 *Be;
   ByTe_2 *Se;
   ByTe_1 **Gn;

   Be = 0;                                              /* set it to NULL    */
   Se = 0;                                              /* set it to NULL    */

   P = (struct Pidf *) PIDF;                            /* PIDF interface    */ 

   if (UpDate == ONEBYTE)                               /* update 1 bytes    */
   {                                                    /* BEG 1 BYTE UPDATE */
      D = P->DCMisc;                                    /* memory shift      */
   
      P->Path += (P->Path > Be) ? D : 0;                /* update path       */
      P->Pf.Institute += (P->Pf.Institute > Be) ? D : 0; /* update institute */
      P->Pf.Project += (P->Pf.Project > Be) ? D : 0;    /* update project    */
      P->Pf.Mission += (P->Pf.Mission > Be) ? D : 0;    /* update mission    */
      P->Pf.Exper += (P->Pf.Exper > Be) ? D : 0;        /* update experiment */
      P->Pf.Inst += (P->Pf.Inst > Be) ? D : 0;          /* update instrument */
      P->Pf.Vinst += (P->Pf.Vinst > Be) ? D : 0;        /* update virtual    */
      P->Pq.LDesc += (P->Pq.LDesc > Be) ? D : 0;        /* update qual lDesc */
      P->Pq.SDesc += (P->Pq.SDesc > Be) ? D : 0;        /* update qual sDesc */
      P->Ap.LDesc += (P->Ap.LDesc > Be) ? D : 0;        /* update Pang lDesc */
      P->Ap.SDesc += (P->Ap.SDesc > Be) ? D : 0;        /* update Pang sDesc */
      P->As.LDesc += (P->As.LDesc > Be) ? D : 0;        /* update Sang lDesc */
      P->As.SDesc += (P->As.SDesc > Be) ? D : 0;        /* update Sang sDesc */
      P->Pi.Storage += (P->Pi.Storage > Be) ? D : 0;    /* update img store  */

      Gn = (ByTe_1 **)P->Groups;                        /* grp name offsets  */
      for (I = 0; I < P->MGroups; ++I)                  /* loop over groups  */
          Gn[I] += (Gn[I] > Be) ? D : 0;                /* update grp name   */

      if (P->Pi.LatLong  != 0)                          /* lat/long struct?  */
      {                                                 /* BEG LAT/LONG      */
         Pl = (struct PidfLatLong *)P->Pi.LatLong;      /* ptr to unit info  */
         Pl->LatDef += (Pl->LatDef > Be) ? D : 0;       /* update long desc  */
         Pl->LongDef += (Pl->LongDef > Be) ? D : 0;     /* update short desc */
      }                                                 /* END LAT/LONG      */

      Pu = (struct PidfUnit *)P->Units;                 /* ptr to unit info  */
      for (I = 0; I < P->MUnits; ++I, ++Pu)             /* loop over units   */
      {                                                 /* BEGIN UNIT LOOP   */
          Pu->LDesc += (Pu->LDesc > Be) ? D : 0;        /* update long desc  */
          Pu->SDesc += (Pu->SDesc > Be) ? D : 0;        /* update short desc */
          Pu->ULab += (Pu->ULab > Be) ? D : 0;          /* update unit lab   */
          Pu->Tbls += (Pu->Tbls > Be) ? D : 0;          /* update unit lab   */
      }                                                 /* END UNIT LOOP     */

      Px = (struct PidfSensor *)P->Sensors;             /* ptr to unit info  */
      for (I = 0; I < P->MSensors; ++I, ++Px)           /* loop over units   */
      {                                                 /* BEGIN SEN LOOP    */
          Px->Name += (Px->Name > Be) ? D : 0;          /* update long desc  */
          Px->Comp += (Px->Comp > Be) ? D : 0;          /* update short desc */
          Px->ScfFile += (Px->ScfFile > Be) ? D : 0;    /* update unit lab   */
      }                                                 /* END SEN LOOP      */

      Pm = (struct PidfMode *)P->Modes;                 /* ptr to unit info  */
      for (I = 0; I < P->MModes; ++I, ++Pm)             /* loop over units   */
      {                                                 /* BEGIN MODE LOOP   */
          Pm->LDesc += (Pm->LDesc > Be) ? D : 0;        /* update long desc  */
          Pm->SDesc += (Pm->SDesc > Be) ? D : 0;        /* update short desc */
      }                                                 /* END MODE LOOP     */

      Pa = (struct PidfAnc *)P->Ancil;                  /* ptr to unit info  */
      for (I = 0; I < P->MAncil; ++I, ++Pa)             /* loop over units   */
      {                                                 /* BEGIN ANC LOOP    */
          Pa->LDesc += (Pa->LDesc > Be) ? D : 0;        /* update long desc  */
          Pa->SDesc += (Pa->SDesc > Be) ? D : 0;        /* update short desc */
      }                                                 /* END ANC LOOP      */
   }                                                    /* END 1 BYTE UPDATE */
   else                                                 /* ok so its TWOBYTE */
   {                                                    /* BEG 2 BYTE UPDATE */
      D = P->DSMisc / 2;                                /* memory shift      */

      P->Pq.Units += (P->Pq.Units > Se) ? D : 0;        /* update qual units */
      P->Ap.Units += (P->Ap.Units > Se) ? D : 0;        /* update Pang units */
      P->As.Units += (P->As.Units > Se) ? D : 0;        /* update Sang units */

      Pu = (struct PidfUnit *)P->Units;                 /* ptr to unit info  */
      for (I = 0; I < P->MUnits; ++I, ++Pu)             /* loop over units   */
          Pu->Ops += (Pu->Ops > Se) ? D : 0;            /* update units      */

      Px = (struct PidfSensor *)P->Sensors;             /* ptr to unit info  */
      for (I = 0; I < P->MSensors; ++I, ++Px)           /* loop over units   */
          Px->Units += (Px->Units > Se) ? D : 0;        /* update units      */

      Pm = (struct PidfMode *)P->Modes;                 /* ptr to unit info  */
      for (I = 0; I < P->MModes; ++I, ++Pm)             /* loop over units   */
          Pm->Units += (Pm->Units > Se) ? D : 0;        /* update units      */

      Pa = (struct PidfAnc *)P->Ancil;                  /* ptr to unit info  */
      for (I = 0; I < P->MAncil; ++I, ++Pa)             /* loop over units   */
      {                                                 /* BEGIN ANC LOOP    */
          Pa->Units += (Pa->Units > Se) ? D : 0;        /* update units      */
          Pa->Sen += (Pa->Sen > Se) ? D : 0;            /* update sen deps   */
      }                                                 /* END ANC LOOP      */
   }                                                    /* END 2 BYTE UPDATE */
}
