#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrUnits (void *PIDF) 
{
   struct Pidf *P;
   struct PidfUnit *Pu;
   
   ByTe_4 I, L1, L2, L;
   ByTe_2 *s1, *sEnD;
   ByTe_1 *c1, *cEnD;

   P = (struct Pidf *)PIDF;

   printf ("\n     **************************************************\n");
   printf ("     *     UNIT BLOCK   %2d TOTAL UNIT DEFINITIONS     *\n", 
                       P->Ps.NUnits);
   printf ("     **************************************************\n\n");

   Pu = (struct PidfUnit *)P->Units;
   for (I = 0; I < P->Ps.NUnits; ++I, ++Pu)
   {                                        
       printf ("*************\n");
       printf ("*  UNIT %2d  *\n", I);
       printf ("*************\n");

       if (Pu->LDesc != 0)
           printf ("              Name:       %s\n", Pu->LDesc);
       if (Pu->SDesc != 0)
           printf ("              Abbr:       %s\n", Pu->SDesc);
       if (Pu->ULab != 0)
           printf ("              Units:      %s\n", Pu->ULab);

       printf ("              Id:         %d\n", Pu->Id);
       printf ("              Local Id:   %d\n", Pu->LocalId);
       printf ("              Minimum:    %.3e\n", Pu->Min);
       printf ("              Maximum:    %.3e\n", Pu->Max);
       printf ("              Scaling:    %d\n", Pu->Sca);
       printf ("              App Opers:  %d\n", Pu->NTbls);

       if (Pu->NTbls > 0) 
       {
          printf ("              Tables:    ");
          c1 = Pu->Tbls;
          s1 = Pu->Ops;
          cEnD = c1 + Pu->NTbls;
          L1 = (*s1 > 999) ? 3 : (*s1 > 99) ? 2 : (*s1 > 9) ? 1 : 0; 
          L2 = (*c1 > 99) ? 2 : (*c1 > 9) ? 1 : 0; 
          L = (L1 > L2) ? L1 : L2;
          switch (L) 
          {
             case 0:
                printf (" %hd", *c1++);
             break;
             case 1:
                printf (" %2hd", *c1++);
             break;
             case 2:
                printf (" %3hd", *c1++);
             break;
             case 3:
                printf (" %4hd", *c1++);
             break;
          }
          ++s1;
          for ( ; c1 < cEnD; ++s1)
          {
             L1 = (*s1 > 999) ? 3 : (*s1 > 99) ? 2 : (*s1 > 9) ? 1 : 0; 
             L2 = (*c1 > 99) ? 2 : (*c1 > 9) ? 1 : 0; 
             L = (L1 > L2) ? L1 : L2;
             switch (L) 
             {
                case 0:
                   printf (" | %hd", *c1++);
                break;
                case 1:
                   printf (" | %2hd", *c1++);
                break;
                case 2:
                   printf (" | %3hd", *c1++);
                break;
                case 3:
                   printf (" | %4hd", *c1++);
                break;
             }
          }
          printf ("\n");

          printf ("              Opers:     ");
          s1 = Pu->Ops;
          sEnD = s1 + Pu->NTbls;
          c1 = Pu->Tbls;
          L1 = (*s1 > 999) ? 3 : (*s1 > 99) ? 2 : (*s1 > 9) ? 1 : 0; 
          L2 = (*c1 > 99) ? 2 : (*c1 > 9) ? 1 : 0; 
          L = (L1 > L2) ? L1 : L2;
          switch (L) 
          {
             case 0:
                printf (" %hd", *s1++);
             break;
             case 1:
                printf (" %2hd", *s1++);
             break;
             case 2:
                printf (" %3hd", *s1++);
             break;
             case 3:
                printf (" %4hd", *s1++);
             break;
          }
          ++c1;
          for ( ; s1 < sEnD; ++c1)
          {
             L1 = (*s1 > 999) ? 3 : (*s1 > 99) ? 2 : (*s1 > 9) ? 1 : 0; 
             L2 = (*c1 > 99) ? 2 : (*c1 > 9) ? 1 : 0; 
             L = (L1 > L2) ? L1 : L2;
             switch (L) 
             {
                case 0:
                   printf (" | %hd", *s1++);
                break;
                case 1:
                   printf (" | %2hd", *s1++);
                break;
                case 2:
                   printf (" | %3hd", *s1++);
                break;
                case 3:
                   printf (" | %4hd", *s1++);
                break;
             }
          }
          printf ("\n\n");
       }
   }            
}
