#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrSensors (void *PIDF) 
{
   struct Pidf *P;
   struct PidfSensor *Px;
   
   ByTe_4 I;
   ByTe_2 *s1, *sEnD;

   P = (struct Pidf *)PIDF;

   printf ("\n     **************************************************\n");
   printf ("     *   SENSOR BLOCK   %2d TOTAL SENSOR DEFINITIONS   *\n", 
                       P->Ps.NSensors);
   printf ("     **************************************************\n\n");

   Px = (struct PidfSensor *)P->Sensors;             /* ptr to unit info  */
   for (I = 0; I < P->Ps.NSensors; ++I, ++Px)        /* loop over units   */
   {                                                 /* BEGIN SEN LOOP    */
       printf ("*************\n");
       printf ("* SENSOR %2d *\n", I);
       printf ("*************\n");

       if (Px->Name != 0)
           printf ("              Name:        %s\n", Px->Name);
       if (Px->Comp != 0)
           printf ("              Comp:        %s\n", Px->Comp);
       printf ("              Source:      %c\n", Px->Src);
       if (Px->Src == 'S' && Px->ScfFile != 0)
           printf ("              ScfFile:     %s\n", Px->ScfFile);
       if (Px->Src == 'A')
           printf ("              AncSenNum:   %d\n", Px->AncSen);
       printf ("              PitchAngle:  %c\n", Px->PitchAng);
       printf ("              PidfNum:     %d\n", Px->PidfNum);
       printf ("              VidfNum:     %d\n", Px->VidfNum);
       printf ("              GroupNum:    %d\n", Px->GroupNum);
       printf ("              Scan Block:  %d\n", Px->ScanBlk);
       printf ("              Binning Def: %d\n", Px->ScanBlk);
       printf ("              # Of Units:  %d\n", Px->NUnits);
       if (Px->NUnits  > 0)
       {
          printf ("              Units:      ");
          s1 = Px->Units;
          sEnD = s1 + Px->NUnits;
          printf (" %hd", *s1++);
          for ( ; s1 < sEnD; )
             printf (" | %hd", *s1++);
          printf ("\n\n");
       }
   }                                                 /* END SEN LOOP      */
}
