#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrScan (void *PIDF) 
{
   struct Pidf *P;
   struct PidfScan *Pc;
   
   ByTe_4 I;
   ByTe_2 *s1, *sEnD;
   ByTe_1 *c1, *cEnD;

   P = (struct Pidf *)PIDF;

   printf ("\n     **************************************************\n");
   printf ("     *     SCAN BLOCK   %2d TOTAL SCAN DEFINITIONS     *\n", 
                       P->Ps.NScans);
   printf ("     **************************************************\n\n");

   Pc = (struct PidfScan *)P->Scans;         
   for (I = 0; I < P->Ps.NScans; ++I, ++Pc) 
   {                                       
       printf ("*************\n");
       printf ("*  SCAN %2d  *\n", I);
       printf ("*************\n");

       printf ("              Step:      ");
       if (Pc->NUnits  > 0)
       {
          c1 = Pc->Step;
          cEnD = c1 + Pc->NUnits;
          printf ("  %c", *c1++);
          for ( ; c1 < cEnD; )
             printf (" |  %c", *c1++);
       }
       printf ("\n");

       if (Pc->NUnits  > 0)
       {
          printf ("              Units1:    ");
          s1 = Pc->Units;
          sEnD = s1 + Pc->NUnits;
          printf (" %2hd", *s1++);
          for ( ; s1 < sEnD; )
             printf (" | %2hd", *s1++);
          printf ("\n");

          printf ("              Location:  ");
          c1 = Pc->Loc;
          cEnD = c1 + Pc->NUnits;
          printf ("  %c", *c1++);
          for ( ; c1 < cEnD; )
             printf (" |  %c", *c1++);
          printf ("\n");

          printf ("              Units2:    ");
          s1 = Pc->VUnits;
          sEnD = s1 + Pc->NUnits;
          printf (" %2hd", *s1++);
          for ( ; s1 < sEnD; )
             printf (" | %2hd", *s1++);
          printf ("\n\n");
       }
   }
}
