#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrImages (void *PIDF) 
{
   struct Pidf *P;
   struct PidfLatLong *Pl;
   
   ByTe_4 I;

   P = (struct Pidf *)PIDF;

   printf ("\n     **************************************************\n");
   printf ("     *                   IMAGE BLOCK                  *\n"); 
   if (P->ImageDef == 0)
      printf ("     *                    UNDEFINED                   *\n");
   printf ("     **************************************************\n\n");

   if (P->ImageDef == 0)
      return;

   printf ("Format:       %c\n", P->Pi.Format);
   printf ("Type:         %c\n", P->Pi.Type);
   printf ("Bin Format:   %c\n", P->Pi.BinType);
   if (P->Pi.Storage != 0)
      printf ("Storage:      %s\n", P->Pi.Storage);
   printf ("# Lat/Longs:  %d\n\n", P->Pi.NLatLong);

   if (P->Pi.NLatLong > 0)
   {
      Pl = (struct PidfLatLong *)P->Pi.LatLong;
      for (I = 0; I < P->Pi.NLatLong; ++I, ++Pl)
      {
          printf ("**************\n");
          printf ("* LATLONG %2d *\n", I);
          printf ("**************\n");

          printf ("              Lat Loc:    %c\n", Pl->LatLoc);
          printf ("              Lat Pos:    %hd\n", Pl->LatNum);
          printf ("              Lat Unit:   %hd\n", Pl->LatUnit);
          if (Pl->LatDef != 0)
             printf ("              Lat Def:    %s\n", Pl->LatDef);
          printf ("              Long Loc:   %c\n", Pl->LongLoc);
          printf ("              Long Pos:   %hd\n", Pl->LongNum);
          printf ("              Long Unit:  %hd\n", Pl->LongUnit);
          if (Pl->LongDef != 0)
             printf ("              Long Def:   %s\n", Pl->LongDef);
      }
   }
}
