#include <stdio.h>
#include "ByteDefs.h"

#ifndef PIDF_STR_H
#define PIDF_STR_H

struct PidfImage {
   ByTe_1 Format;
   ByTe_1 Type;
   ByTe_1 BinType;
   ByTe_1 *Storage;
   ByTe_2 NLatLong;
   ByTe_2 MLatLongs;
   void   *LatLong;
};

struct PidfLatLong {
   ByTe_1 LatLoc;
   ByTe_1 LongLoc;
   ByTe_2 LatNum;
   ByTe_2 LongNum;
   ByTe_2 LatUnit;
   ByTe_2 LongUnit;
   ByTe_1 *LatDef;
   ByTe_1 *LongDef;
};

struct PidfQual {
   ByTe_1 *LDesc;
   ByTe_1 *SDesc;
   ByTe_2 NUnits;
   ByTe_2 *Units;
};

struct PidfPAng {
   ByTe_1 *LDesc;
   ByTe_1 *SDesc;
   ByTe_2 PaVSen;
   ByTe_2 NUnits;
   ByTe_2 *Units;
};

struct PidfSAng {
   ByTe_1 *LDesc;
   ByTe_1 *SDesc;
   ByTe_2 NUnits;
   ByTe_2 *Units;
};

struct PidfSizes
{
   ByTe_2 NGroups;
   ByTe_2 NUnits;
   ByTe_2 NSensors;
   ByTe_2 NScans;
   ByTe_2 NBins;
   ByTe_2 NAncils;
   ByTe_2 NModes;
};

struct PidfFixed {
   ReaL_4 Version;
   ByTe_1 *Institute;
   ByTe_1 *Project;
   ByTe_1 *Mission;
   ByTe_1 *Exper;
   ByTe_1 *Inst;
   ByTe_1 *Vinst;
   ByTe_2 PlotTypes;
   ByTe_2 DataTypes;
   ByTe_2 Depends;
   ByTe_2 Blocking;
   ReaL_4 PhiMin;
   ReaL_4 PhiMax;
   ReaL_4 ThetaMin;
   ReaL_4 ThetaMax;
   ReaL_4 ScanMin;
   ReaL_4 ScanMax;
   ReaL_4 MassMin;
   ReaL_4 MassMax;
   ReaL_4 ChargeMin;
   ReaL_4 ChargeMax;
   ReaL_4 EnergyMin;
   ReaL_4 EnergyMax;
   ReaL_4 FreqMin;
   ReaL_4 FreqMax;
   ByTe_1 Cyclic;
   ByTe_1 SenType;
};

struct Pidf {
   u_ByTe_4          Key;                         /* current open Key        */
   FILE              *Fp;                         /* current pidf file desc  */
   ByTe_1            *Path;                       /* path to IDFS            */
   struct PidfFixed  Pf;                          /* Pidf fixed entries      */
   struct PidfSizes  Ps;                          /* Pidf number of values   */
   struct PidfQual   Pq;                          /* Pidf quality structure  */
   struct PidfImage  Pi;                          /* Pidf image structure    */
   struct PidfPAng   Ap;                          /* Pidf pitchang structure */
   struct PidfSAng   As;                          /* Pidf spinang structure  */
   ByTe_1            ImageDef;                    /* image block found       */
   ByTe_1            QualDef;                     /* quality block found     */
   ByTe_1            PAngDef;                     /* pitch angle block found */
   ByTe_1            SAngDef;                     /* spin angle block found  */
   ByTe_2            MUnits;                      /* num of malloced units   */
   ByTe_2            MSensors;                    /* num of malloced sensors */
   ByTe_2            MGroups;                     /* num of malloced grp nms */
   ByTe_2            MScans;                      /* num of malloced scans   */
   ByTe_2            MAncil;                      /* num of malloced ancils  */
   ByTe_2            MModes;                      /* num of malloced modes   */
   ByTe_2            MBins;                       /* num of malloced bins    */
   ByTe_2            MCMisc;                      /* length of one byte area */
   ByTe_2            MSMisc;                      /* num of 2 byte elements  */
   ByTe_2            NFGrp;                       /* offset to next free grp */
   ByTe_2            NFCMisc;                     /* next free 1 byte misc   */
   ByTe_2            NFSMisc;                     /* next free 2 byte misc   */
   ByTe_4            DCMisc;                      /* 1 byte mem shift        */
   ByTe_4            DSMisc;                      /* 2 byte mem shift        */
   void              *Groups;                     /* group name area         */
   void              *Units;                      /* unit structures area    */
   void              *Sensors;                    /* sensor structures area  */
   void              *Scans;                      /* scan blk structure area */
   void              *Ancil;                      /* ancil structures area   */
   void              *Modes;                      /* mode structures area    */
   void              *Bins;                       /* bin structures area     */
   void              *CMisc;                      /* misc one byte area      */
   void              *SMisc;                      /* misc two byte area      */
};

struct PidfBin {
   ByTe_2 Method;
   ByTe_2 Sca;
   ReaL_4 Min;
   ReaL_4 Max;
   ByTe_4 NBins;
};

struct PidfUnit {
   ByTe_4 Id;
   ByTe_4 LocalId;
   ReaL_4 Min;
   ReaL_4 Max;
   ByTe_1 *ULab;
   ByTe_1 *LDesc;
   ByTe_1 *SDesc;
   ByTe_2 Sca;
   ByTe_2 NTbls;
   ByTe_1 *Tbls;
   ByTe_2 *Ops;
};

struct PidfSensor {
   ByTe_1 *Name;
   ByTe_1 *Comp;
   ByTe_1 Src;
   ByTe_1 *ScfFile;
   ByTe_1 PitchAng;
   ByTe_1 Display;
   ByTe_2 PidfNum;
   ByTe_2 VidfNum;
   ByTe_2 AncSen;
   ByTe_2 GroupNum;
   ByTe_2 ScanBlk;
   ByTe_2 BinBlk;
   ByTe_2 NUnits;
   ByTe_2 *Units;
};

struct PidfMode {
   ByTe_1 *LDesc;
   ByTe_1 *SDesc;
   ByTe_2 PidfNum;
   ByTe_2 VidfNum;
   ByTe_2 NUnits;
   ByTe_2 *Units;
};

struct PidfAnc {
   ByTe_1 *LDesc;
   ByTe_1 *SDesc;
   ByTe_2 PidfNum;
   ByTe_2 VidfNum;
   ByTe_2 NUnits;
   ByTe_2 *Units;
   ByTe_2 NSen;
   ByTe_2 *Sen;
   ByTe_1 Modify;
};

struct PidfScan {
   ByTe_2 NUnits;
   ByTe_2 *Units;
   ByTe_2 *VUnits;
   ByTe_1 *Loc;
   ByTe_1 *Step;
};

#endif
