#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"

void PidfSizes (void *PIDF, ByTe_1 *Id, ByTe_1 *Val) 
{
   struct Pidf *P;

   ByTe_2 V;
   ByTe_1 *c1;

   P = (struct Pidf *) PIDF;                      /* PIDF interface struct  */ 
   c1 = Id + 4;                                   /* Size Id String         */
      
   sscanf (Val, "%hd", &V);                       /* get the size            */
   switch (*c1)                                   /* switch on id char       */
   {                                              /* BEGIN PIDF SIZE SWITCH  */
      case 'b':                                   /* START CASE 'b'          */
         if (strcmp(c1, "bin_sets") == 0)         /* scan bin size?          */
         {                                        /* BEGIN PROCESS BIN SIZE  */
            P->Ps.NBins = V;                      /* set size                */
            ChkPidfMem (PIDF, BINS, V);           /* do memory check         */
         }                                        /* END PROCESS BIN SIZE    */
      break;                                      /* STOP  CASE 'b'          */ 
      case 'c':                                   /* START CASE 'b'          */
         if (strcmp(c1, "cals") == 0)             /* ancil size?             */
         {                                        /* BEGIN PROCESS ANC SIZE  */
            P->Ps.NAncils = V;                    /* set size                */
            ChkPidfMem (PIDF, ANCIL, V);          /* do memory check         */
         }                                        /* END PROCESS ANC SIZE    */
      break;                                      /* STOP  CASE 'b'          */ 
      case 'g':                                   /* START CASE 'g'          */
         if (strcmp(c1, "groups") == 0)           /* group size?             */
         {                                        /* BEGIN PROCESS GRP SIZE  */
            P->Ps.NGroups = V;                    /* set size                */
            ChkPidfMem (PIDF, GROUPS, V);         /* do memory check         */
         }                                        /* END PROCESS GRP SIZE    */
      break;                                      /* STOP  CASE 'g'          */ 
      case 'm':                                   /* START CASE 'm'          */
         if (strcmp(c1, "modes") == 0)            /* mode size?              */
         {                                        /* BEGIN PROCESS MODE SIZE */
            P->Ps.NModes = V;                     /* set size                */
            ChkPidfMem (PIDF, MODES, V);          /* do memory check         */
         }                                        /* END PROCESS MODE SIZE   */
      break;                                      /* STOP  CASE 'm'          */ 
      case 's':                                   /* START CASE 's'          */
         if (strcmp(c1, "sensors") == 0)          /* sensor size?            */
         {                                        /* BEGIN PROCESS SEN SIZE  */
            P->Ps.NSensors = V;                   /* set size                */
            ChkPidfMem (PIDF, SENSORS, V);        /* do memory check         */
         }                                        /* END PROCESS SEN SIZE    */
         else                                     /* must be scan blocks     */
            if (strcmp(c1, "scan") == 0)          /* scan block size?        */
            {                                     /* BEGIN PROCESS SCAN SIZE */
               P->Ps.NScans = V;                  /* set size                */
               ChkPidfMem (PIDF, SCANS, V);       /* do memory check         */
            }                                     /* END PROCESS SCAN SIZE   */
      break;                                      /* STOP  CASE 's'          */ 
      case 'u':                                   /* START CASE 'u'          */
         if (strcmp(c1, "units") == 0)            /* units size?             */
         {                                        /* BEGIN PROCESS UNIT SIZE */
            P->Ps.NUnits = V;                     /* set size                */
            ChkPidfMem (PIDF, UNITS, V);          /* do memory check         */
         }                                        /* END PROCESS UNIT SIZE   */
      break;                                      /* STOP  CASE 'u'          */ 
   }                                              /* END PIDF ITEM SWITCH    */
}
